/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.util.log;

import android.util.Log;
import com.emarsys.core.util.log.EMSLoggerSettings;
import com.emarsys.core.util.log.LogTopic;

public class EMSLogger {
    private EMSLogger() {
    }

    public static void log(LogTopic topic, String message) {
        if (EMSLoggerSettings.isEnabled(topic)) {
            EMSLogger.log(topic.getTag(), message);
        }
    }

    public static void log(LogTopic topic, String message, Object ... args) {
        if (EMSLoggerSettings.isEnabled(topic)) {
            EMSLogger.log(topic.getTag(), String.format(message, args));
        }
    }

    private static void log(String tag, String rawMessage) {
        Log.i((String)tag, (String)EMSLogger.createMessage(rawMessage));
    }

    private static String createMessage(String rawMessage) {
        StackTraceElement stackTraceElement = EMSLogger.getStackTraceElement();
        return String.format("[%s] - %s::%s:%s\n%s", Thread.currentThread().getName(), stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber(), rawMessage);
    }

    private static StackTraceElement getStackTraceElement() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 0;
        while (!stackTrace[i].getClassName().equals(EMSLogger.class.getName())) {
            ++i;
        }
        while (stackTrace[i].getClassName().equals(EMSLogger.class.getName())) {
            ++i;
        }
        return stackTrace[i];
    }
}

