/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.response;

import com.emarsys.core.request.model.RequestModel;
import com.emarsys.core.timestamp.TimestampProvider;
import com.emarsys.core.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseModel {
    private final int statusCode;
    private final String message;
    private final Map<String, String> headers;
    private final String body;
    private final long timestamp;
    private final RequestModel requestModel;

    ResponseModel(int statusCode, String message, Map<String, String> headers, String body, long timestamp, RequestModel requestModel) {
        this.checkStatusCode(statusCode);
        Assert.notNull(message, "Message must not be null!");
        Assert.notNull(headers, "Headers must not be null!");
        Assert.notNull(requestModel, "RequestModel must not be null!");
        this.statusCode = statusCode;
        this.message = message;
        this.headers = headers;
        this.body = body;
        this.timestamp = timestamp;
        this.requestModel = requestModel;
    }

    private void checkStatusCode(int statusCode) {
        if (statusCode < 200 || statusCode >= 600) {
            throw new IllegalArgumentException("Status code must be between 2xx and 5xx!");
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public JSONObject getParsedBody() {
        JSONObject result = null;
        if (this.body != null) {
            try {
                result = new JSONObject(this.body);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public RequestModel getRequestModel() {
        return this.requestModel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseModel that = (ResponseModel)o;
        if (this.statusCode != that.statusCode) {
            return false;
        }
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        return this.requestModel != null ? this.requestModel.equals(that.requestModel) : that.requestModel == null;
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.requestModel != null ? this.requestModel.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResponseModel{statusCode=" + this.statusCode + ", message='" + this.message + '\'' + ", headers=" + this.headers + ", body='" + this.body + '\'' + ", timestamp=" + this.timestamp + ", requestModel=" + this.requestModel + '}';
    }

    public static class Builder {
        private int statusCode;
        private String message;
        private Map<String, String> headers = new HashMap<String, String>();
        private String body;
        private RequestModel requestModel;
        private TimestampProvider timestampProvider;

        public Builder() {
            this(new TimestampProvider());
        }

        public Builder(TimestampProvider timestampProvider) {
            this.timestampProvider = timestampProvider;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = this.convertHeaders(headers);
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder requestModel(RequestModel requestModel) {
            this.requestModel = requestModel;
            return this;
        }

        public ResponseModel build() {
            return new ResponseModel(this.statusCode, this.message, this.headers, this.body, this.timestampProvider.provideTimestamp(), this.requestModel);
        }

        Map<String, String> convertHeaders(Map<String, List<String>> headers) {
            HashMap<String, String> result = new HashMap<String, String>();
            Set<Map.Entry<String, List<String>>> entries = headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entries) {
                result.put(entry.getKey(), this.join("; ", entry.getValue()));
            }
            return result;
        }

        String join(String delimiter, List<String> strings) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = strings.iterator();
            if (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append(delimiter);
                    stringBuilder.append(iterator.next());
                }
            }
            return stringBuilder.toString();
        }
    }
}

