/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request;

import android.os.AsyncTask;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.database.repository.Repository;
import com.emarsys.core.database.repository.SqlSpecification;
import com.emarsys.core.request.model.RequestMethod;
import com.emarsys.core.request.model.RequestModel;
import com.emarsys.core.response.ResponseModel;
import com.emarsys.core.timestamp.TimestampProvider;
import com.emarsys.core.util.Assert;
import com.emarsys.core.util.JsonUtils;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class RequestTask
extends AsyncTask<Void, Long, Void> {
    private static final int TIMEOUT = 30000;
    private final RequestModel requestModel;
    private final CoreCompletionHandler handler;
    private Repository<Map<String, Object>, SqlSpecification> logRepository;
    private TimestampProvider timestampProvider;
    private ResponseModel responseModel;
    private Exception exception;

    public RequestTask(RequestModel requestModel, CoreCompletionHandler handler, Repository<Map<String, Object>, SqlSpecification> logRepository, TimestampProvider timestampProvider) {
        Assert.notNull(requestModel, "RequestModel must not be null!");
        Assert.notNull(handler, "CoreCompletionHandler must not be null!");
        Assert.notNull(logRepository, "LogRepository must not be null!");
        Assert.notNull(timestampProvider, "TimestampProvider must not be null!");
        this.requestModel = requestModel;
        this.handler = handler;
        this.logRepository = logRepository;
        this.timestampProvider = timestampProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(Void ... params) {
        EMSLogger.log(CoreTopic.NETWORKING, "RequestModel: %s", this.requestModel);
        long dbEnd = this.timestampProvider.provideTimestamp();
        this.logMetric("in_database", this.requestModel.getTimestamp(), dbEnd);
        HttpsURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)this.requestModel.getUrl().openConnection();
            this.initializeConnection(connection, this.requestModel);
            connection.setConnectTimeout(20000);
            connection.connect();
            this.sendBody(connection, this.requestModel);
            this.responseModel = this.readResponse(connection);
            this.logMetric("networking_time", dbEnd, this.responseModel.getTimestamp());
        }
        catch (IOException ioe) {
            this.exception = ioe;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    protected void onPostExecute(Void result) {
        if (this.exception != null) {
            EMSLogger.log(CoreTopic.NETWORKING, "Exception: %s", this.exception);
            this.handler.onError(this.requestModel.getId(), this.exception);
        } else if (this.responseModel != null) {
            EMSLogger.log(CoreTopic.NETWORKING, "ResponseModel: %s", this.responseModel);
            if (this.isStatusCodeOK(this.responseModel.getStatusCode())) {
                this.handler.onSuccess(this.requestModel.getId(), this.responseModel);
            } else {
                this.handler.onError(this.requestModel.getId(), this.responseModel);
            }
        }
    }

    public RequestModel getRequestModel() {
        return this.requestModel;
    }

    public CoreCompletionHandler getHandler() {
        return this.handler;
    }

    private void logMetric(String metricName, long start, long end) {
        HashMap<String, String> metric = new HashMap<String, String>();
        metric.put("request_id", this.requestModel.getId());
        metric.put(metricName, String.valueOf(end - start));
        metric.put("url", this.requestModel.getUrl().toString());
        this.logRepository.add(metric);
    }

    private void initializeConnection(HttpsURLConnection connection, RequestModel model) throws IOException {
        connection.setRequestMethod(model.getMethod().name());
        this.setHeaders(connection, model.getHeaders());
        connection.setConnectTimeout(30000);
        if (model.getMethod() != RequestMethod.GET && model.getPayload() != null) {
            connection.setDoOutput(true);
        }
    }

    private void setHeaders(HttpsURLConnection connection, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            connection.setRequestProperty(key, value);
        }
    }

    private void sendBody(HttpsURLConnection connection, RequestModel model) throws IOException {
        if (model.getPayload() != null) {
            byte[] payload = JsonUtils.fromMap(model.getPayload()).toString().getBytes("UTF-8");
            BufferedOutputStream writer = new BufferedOutputStream(connection.getOutputStream());
            writer.write(payload);
            writer.close();
        }
    }

    private ResponseModel readResponse(HttpsURLConnection connection) throws IOException {
        int statusCode = connection.getResponseCode();
        String message = connection.getResponseMessage();
        Map<String, List<String>> headers = connection.getHeaderFields();
        String body = this.readBody(connection);
        return new ResponseModel.Builder(this.timestampProvider).statusCode(statusCode).message(message).headers(headers).body(body).requestModel(this.requestModel).build();
    }

    private String readBody(HttpsURLConnection connection) throws IOException {
        String inputLine;
        int responseCode = connection.getResponseCode();
        InputStream inputStream = this.isStatusCodeOK(responseCode) ? connection.getInputStream() : connection.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        while ((inputLine = reader.readLine()) != null) {
            sb.append(inputLine);
        }
        reader.close();
        return sb.toString();
    }

    private boolean isStatusCodeOK(int responseCode) {
        return 200 <= responseCode && responseCode < 300;
    }
}

