/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.connection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import com.emarsys.core.connection.ConnectionChangeListener;
import com.emarsys.core.connection.ConnectionState;
import com.emarsys.core.util.Assert;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;

public class ConnectionWatchDog {
    IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    BroadcastReceiver receiver;
    ConnectivityManager connectivityManager;
    Context context;
    Handler coreSdkHandler;

    protected ConnectionWatchDog() {
    }

    public ConnectionWatchDog(Context context, Handler coreSdkHandler) {
        Assert.notNull(context, "Context must not be null!");
        Assert.notNull(coreSdkHandler, "CoreSdkHandler must not be null!");
        this.context = context.getApplicationContext();
        this.coreSdkHandler = coreSdkHandler;
        this.connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
    }

    public ConnectionState getConnectionState() {
        NetworkInfo activeNetwork = this.connectivityManager.getActiveNetworkInfo();
        if (activeNetwork == null || !activeNetwork.isConnected()) {
            return ConnectionState.DISCONNECTED;
        }
        if (0 == activeNetwork.getType() || 4 == activeNetwork.getType()) {
            return ConnectionState.CONNECTED_MOBILE_DATA;
        }
        return ConnectionState.CONNECTED;
    }

    public boolean isConnected() {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        boolean isConnected = networkInfo != null && networkInfo.isConnected();
        EMSLogger.log(CoreTopic.CONNECTIVITY, "Connected to the network: %s", isConnected);
        return isConnected;
    }

    public void registerReceiver(ConnectionChangeListener connectionChangeListener) {
        if (this.receiver != null) {
            throw new IllegalStateException("Register receiver cannot be called multiple times!");
        }
        this.receiver = new ConnectivityChangeReceiver(connectionChangeListener);
        this.context.registerReceiver(this.receiver, this.intentFilter);
    }

    class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        ConnectionChangeListener connectionChangeListener;

        public ConnectivityChangeReceiver(ConnectionChangeListener connectionChangeListener) {
            Assert.notNull(connectionChangeListener, "ConnectionChangeListener must not be null!");
            this.connectionChangeListener = connectionChangeListener;
        }

        public void onReceive(Context context, Intent intent) {
            final ConnectionState connectionState = ConnectionWatchDog.this.getConnectionState();
            final boolean isConnected = ConnectionWatchDog.this.isConnected();
            EMSLogger.log(CoreTopic.CONNECTIVITY, "ConnectionState: %s, isConnected: %s", new Object[]{connectionState, isConnected});
            ConnectionWatchDog.this.coreSdkHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConnectivityChangeReceiver.this.connectionChangeListener.onConnectionChanged(connectionState, isConnected);
                }
            });
        }
    }
}

