/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.webkit.URLUtil;
import com.emarsys.core.DeviceInfo;
import com.emarsys.core.util.FileUtils;
import java.io.File;

public class ImageUtils {
    public static Bitmap loadBitmap(Context context, String imageUrl) {
        Bitmap result = null;
        if (ImageUtils.validateParameters(context, imageUrl)) {
            String fileUrl = ImageUtils.downloadImage(context, imageUrl);
            result = ImageUtils.loadBitmap(fileUrl, Integer.MAX_VALUE);
            if (fileUrl != null && ImageUtils.isRemoteUrl(imageUrl)) {
                FileUtils.delete(fileUrl);
            }
        }
        return result;
    }

    public static Bitmap loadOptimizedBitmap(Context context, String imageUrl) {
        Bitmap result = null;
        if (ImageUtils.validateParameters(context, imageUrl)) {
            String fileUrl = ImageUtils.downloadImage(context, imageUrl);
            DeviceInfo deviceInfo = new DeviceInfo(context);
            result = ImageUtils.loadBitmap(fileUrl, deviceInfo.getDisplayMetrics().widthPixels);
            if (fileUrl != null && ImageUtils.isRemoteUrl(imageUrl)) {
                FileUtils.delete(fileUrl);
            }
        }
        return result;
    }

    private static boolean validateParameters(Context context, String imageUrl) {
        boolean result = true;
        if (context == null || imageUrl == null) {
            result = false;
        } else if (!URLUtil.isHttpsUrl((String)imageUrl)) {
            result = new File(imageUrl).exists();
        }
        return result;
    }

    private static String downloadImage(Context context, String imageUrl) {
        String fileUrl = imageUrl;
        if (ImageUtils.isRemoteUrl(imageUrl)) {
            fileUrl = FileUtils.download(context, imageUrl);
        }
        return fileUrl;
    }

    private static boolean isRemoteUrl(String imageUrl) {
        return URLUtil.isHttpsUrl((String)imageUrl);
    }

    private static Bitmap loadBitmap(String imageFileUrl, int width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFileUrl, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, width);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFileUrl, (BitmapFactory.Options)options);
    }

    static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth) {
        int width = options.outWidth;
        int inSampleSize = 1;
        while (reqWidth <= width / inSampleSize) {
            inSampleSize *= 2;
        }
        return inSampleSize;
    }
}

