/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.util;

import com.emarsys.core.util.Assert;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static JSONObject fromMap(Map<String, Object> map) {
        Assert.notNull(map, "Map must not be null!");
        JSONObject result = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    result.put(key, (Object)JsonUtils.fromMap((Map)value));
                    continue;
                }
                if (value instanceof List) {
                    result.put(key, (Object)JsonUtils.fromList((List)value));
                    continue;
                }
                result.put(key, value);
            }
        }
        catch (JSONException je) {
            throw new IllegalArgumentException(je);
        }
        return result;
    }

    public static JSONArray fromList(List<Object> list) {
        Assert.notNull(list, "List must not be null!");
        JSONArray result = new JSONArray();
        for (Object item : list) {
            if (item instanceof List) {
                result.put((Object)JsonUtils.fromList((List)item));
                continue;
            }
            if (item instanceof Map) {
                result.put((Object)JsonUtils.fromMap((Map)item));
                continue;
            }
            result.put(item);
        }
        return result;
    }
}

