/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.database.repository;

import android.content.ContentValues;
import android.database.Cursor;
import com.emarsys.core.database.CoreSQLiteDatabase;
import com.emarsys.core.database.helper.DbHelper;
import com.emarsys.core.database.repository.Repository;
import com.emarsys.core.database.repository.SqlSpecification;
import com.emarsys.core.util.Assert;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSqliteRepository<T>
implements Repository<T, SqlSpecification> {
    String tableName;
    DbHelper dbHelper;

    public AbstractSqliteRepository(String tableName, DbHelper dbHelper) {
        this.tableName = tableName;
        this.dbHelper = dbHelper;
    }

    protected abstract ContentValues contentValuesFromItem(T var1);

    protected abstract T itemFromCursor(Cursor var1);

    @Override
    public final void add(T item) {
        Assert.notNull(item, "Item must not be null!");
        ContentValues contentValues = this.contentValuesFromItem(item);
        CoreSQLiteDatabase database = this.dbHelper.getWritableCoreDatabase();
        database.beginTransaction();
        database.insert(this.tableName, null, contentValues);
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    @Override
    public final List<T> query(SqlSpecification specification) {
        Assert.notNull(specification, "Specification must not be null!");
        CoreSQLiteDatabase database = this.dbHelper.getReadableCoreDatabase();
        Cursor cursor = database.rawQuery(specification.getSql(), specification.getArgs());
        return this.mapCursorToResultList(cursor);
    }

    @Override
    public final void remove(SqlSpecification specification) {
        Assert.notNull(specification, "Specification must not be null!");
        CoreSQLiteDatabase database = this.dbHelper.getWritableCoreDatabase();
        database.beginTransaction();
        database.delete(this.tableName, specification.getSql(), specification.getArgs());
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    @Override
    public boolean isEmpty() {
        CoreSQLiteDatabase database = this.dbHelper.getReadableCoreDatabase();
        Cursor cursor = database.rawQuery(String.format("SELECT COUNT(*) FROM %s;", this.tableName), null);
        cursor.moveToFirst();
        int count = cursor.getInt(cursor.getColumnIndex("COUNT(*)"));
        cursor.close();
        return count == 0;
    }

    private List<T> mapCursorToResultList(Cursor cursor) {
        ArrayList<T> result = new ArrayList<T>();
        if (cursor.moveToFirst()) {
            while (!cursor.isAfterLast()) {
                T item = this.itemFromCursor(cursor);
                result.add(item);
                cursor.moveToNext();
            }
        }
        cursor.close();
        return result;
    }
}

