/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.activity;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.emarsys.core.activity.ApplicationStartAction;
import com.emarsys.core.util.Assert;

public class ApplicationStartWatchdog
implements Application.ActivityLifecycleCallbacks {
    private Activity currentActivity;
    private final ApplicationStartAction[] applicationStartActions;

    public ApplicationStartWatchdog(ApplicationStartAction[] applicationStartActions) {
        Assert.notNull(applicationStartActions, "ApplicationStartActions must not be null!");
        Assert.elementsNotNull(applicationStartActions, "ApplicationStartActions must not contain null elements!");
        this.applicationStartActions = applicationStartActions;
    }

    public ApplicationStartAction[] getApplicationStartActions() {
        return this.applicationStartActions;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (this.currentActivity == null) {
            for (ApplicationStartAction action : this.applicationStartActions) {
                action.execute();
            }
        }
        this.currentActivity = activity;
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (this.currentActivity == activity) {
            this.currentActivity = null;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

