package com.emarsys.core.activity;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import com.emarsys.core.util.Assert;


public class ApplicationStartWatchdog implements Application.ActivityLifecycleCallbacks {

    private Activity currentActivity;
    private final ApplicationStartAction[] applicationStartActions;

    public ApplicationStartWatchdog(ApplicationStartAction[] applicationStartActions) {
        Assert.notNull(applicationStartActions, "ApplicationStartActions must not be null!");
        Assert.elementsNotNull(applicationStartActions, "ApplicationStartActions must not contain null elements!");
        this.applicationStartActions = applicationStartActions;
    }

    public ApplicationStartAction[] getApplicationStartActions() {
        return applicationStartActions;
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {
        if (currentActivity == null) {
            for (ApplicationStartAction action : applicationStartActions) {
                action.execute();
            }
        }
        currentActivity = activity;
    }

    @Override
    public void onActivityPaused(Activity activity) {
    }

    @Override
    public void onActivityStopped(Activity activity) {
        if (currentActivity == activity) {
            currentActivity = null;
        }
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }

}
