/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.response;

import com.emarsys.core.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResponseModel {
    private final int statusCode;
    private final String message;
    private final Map<String, String> headers;
    private final String body;

    ResponseModel(int statusCode, String message, Map<String, String> headers, String body) {
        this.checkStatusCode(statusCode);
        Assert.notNull(message, "Message must not be null!");
        Assert.notNull(headers, "Headers must not be null!");
        this.statusCode = statusCode;
        this.message = message;
        this.headers = headers;
        this.body = body;
    }

    private void checkStatusCode(int statusCode) {
        if (statusCode < 200 || statusCode >= 600) {
            throw new IllegalArgumentException("Status code must be between 2xx and 5xx!");
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseModel that = (ResponseModel)o;
        if (this.getStatusCode() != that.getStatusCode()) {
            return false;
        }
        if (!this.getMessage().equals(that.getMessage())) {
            return false;
        }
        if (!this.getHeaders().equals(that.getHeaders())) {
            return false;
        }
        return this.getBody() != null ? this.getBody().equals(that.getBody()) : that.getBody() == null;
    }

    public int hashCode() {
        int result = this.getStatusCode();
        result = 31 * result + this.getMessage().hashCode();
        result = 31 * result + this.getHeaders().hashCode();
        result = 31 * result + (this.getBody() != null ? this.getBody().hashCode() : 0);
        return result;
    }

    public static class Builder {
        private int statusCode;
        private String message;
        private Map<String, String> headers = new HashMap<String, String>();
        private String body;

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = this.convertHeaders(headers);
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public ResponseModel build() {
            return new ResponseModel(this.statusCode, this.message, this.headers, this.body);
        }

        Map<String, String> convertHeaders(Map<String, List<String>> headers) {
            HashMap<String, String> result = new HashMap<String, String>();
            Set<Map.Entry<String, List<String>>> entries = headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entries) {
                result.put(entry.getKey(), this.join("; ", entry.getValue()));
            }
            return result;
        }

        String join(String delimiter, List<String> strings) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = strings.iterator();
            if (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append(delimiter);
                    stringBuilder.append(iterator.next());
                }
            }
            return stringBuilder.toString();
        }
    }
}

