/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.worker;

import android.os.Handler;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionChangeListener;
import com.emarsys.core.connection.ConnectionState;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.RestClient;
import com.emarsys.core.util.Assert;
import com.emarsys.core.worker.CoreCompletionHandlerMiddleware;
import com.emarsys.core.worker.Worker;

public class DefaultWorker
implements ConnectionChangeListener,
Worker {
    Queue<RequestModel> queue;
    ConnectionWatchDog connectionWatchDog;
    boolean locked;
    CoreCompletionHandler coreCompletionHandler;
    RestClient restClient;
    Handler handler;

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, Handler handler, CoreCompletionHandler coreCompletionHandler) {
        this(queue, connectionWatchDog, handler, coreCompletionHandler, new RestClient());
    }

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, Handler handler, CoreCompletionHandler coreCompletionHandler, RestClient restClient) {
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(handler, "Handler must not be null!");
        Assert.notNull(coreCompletionHandler, "CoreCompletionHandler must not be null!");
        Assert.notNull(restClient, "Restclient must not be null!");
        this.coreCompletionHandler = coreCompletionHandler;
        this.queue = queue;
        this.connectionWatchDog = connectionWatchDog;
        this.connectionWatchDog.registerReceiver(this);
        this.handler = handler;
        this.restClient = restClient;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void run() {
        if (!this.isLocked() && this.connectionWatchDog.isConnected() && !this.queue.isEmpty()) {
            this.lock();
            RequestModel model = this.queue.peek();
            this.restClient.execute(model, new CoreCompletionHandlerMiddleware(this, this.queue, this.handler, this.coreCompletionHandler));
        }
    }

    @Override
    public void onConnectionChanged(ConnectionState connectionState, boolean isConnected) {
        if (isConnected) {
            this.run();
        }
    }
}

