package com.emarsys.core.request;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;

import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.util.Assert;

public class RestClient {

    private final Handler handler = new Handler(Looper.getMainLooper());

    public void execute(RequestModel model, CoreCompletionHandler completionHandler) {
        Assert.notNull(model, "Model must not be null!");
        Assert.notNull(completionHandler, "CoreCompletionHandler must not be null!");
        final RequestTask task = new RequestTask(model, completionHandler);

        if (Looper.myLooper() == Looper.getMainLooper()) {
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR);
        } else {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR);
                }
            });
        }
    }
}
