/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.worker;

import android.os.Handler;
import android.os.Looper;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.response.ResponseModel;
import com.emarsys.core.util.Assert;
import com.emarsys.core.worker.Worker;

public class CoreCompletionHandlerMiddleware
implements CoreCompletionHandler {
    CoreCompletionHandler coreCompletionHandler;
    Queue<RequestModel> queue;
    Worker worker;
    Handler handler;
    Runnable runWorker;

    public CoreCompletionHandlerMiddleware(Worker worker, Queue<RequestModel> queue, CoreCompletionHandler coreCompletionHandler) {
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(worker, "Worker must not be null!");
        Assert.notNull(coreCompletionHandler, "CoreCompletionHandler must not be null!");
        this.coreCompletionHandler = coreCompletionHandler;
        this.queue = queue;
        this.worker = worker;
        this.handler = new Handler(Looper.getMainLooper());
        this.runWorker = new Runnable(){

            @Override
            public void run() {
                CoreCompletionHandlerMiddleware.this.worker.run();
            }
        };
    }

    @Override
    public void onSuccess(String id, ResponseModel responseModel) {
        this.queue.pop();
        this.coreCompletionHandler.onSuccess(id, responseModel);
        this.handler.post(this.runWorker);
        this.worker.unlock();
    }

    @Override
    public void onError(String id, ResponseModel responseModel) {
        if (this.isNonRetriableError(responseModel.getStatusCode())) {
            this.queue.pop();
            this.coreCompletionHandler.onError(id, responseModel);
            this.handler.post(this.runWorker);
        }
        this.worker.unlock();
    }

    private boolean isNonRetriableError(int statusCode) {
        if (statusCode == 408) {
            return false;
        }
        return 400 <= statusCode && statusCode < 500;
    }

    @Override
    public void onError(String id, Exception cause) {
        this.coreCompletionHandler.onError(id, cause);
        this.worker.unlock();
    }
}

