/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request;

import com.emarsys.core.request.RequestMethod;
import com.emarsys.core.util.Assert;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class RequestModel
implements Serializable {
    private URL url;
    private RequestMethod method;
    private Map<String, Object> payload;
    private Map<String, String> headers;
    private Date timestamp;
    private String id;

    public RequestModel(String url, RequestMethod method, Map<String, Object> payload, Map<String, String> headers, Date timestamp, String id) {
        Assert.notNull(url, "Url must not be null!");
        Assert.notNull((Object)method, "Method must not be null!");
        Assert.notNull(headers, "Headers must not be null!");
        Assert.notNull(timestamp, "Timestamp must not be null!");
        Assert.notNull(id, "Id must not be null!");
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException(mue);
        }
        this.method = method;
        this.payload = payload;
        this.headers = headers;
        this.timestamp = timestamp;
        this.id = id;
    }

    public static String nextId() {
        return UUID.randomUUID().toString();
    }

    public URL getUrl() {
        return this.url;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestModel that = (RequestModel)o;
        if (!this.getUrl().equals(that.getUrl())) {
            return false;
        }
        if (this.getMethod() != that.getMethod()) {
            return false;
        }
        if (this.getPayload() != null ? !this.getPayload().equals(that.getPayload()) : that.getPayload() != null) {
            return false;
        }
        if (this.getHeaders() != null ? !this.getHeaders().equals(that.getHeaders()) : that.getHeaders() != null) {
            return false;
        }
        if (this.getTimestamp() != null ? !this.getTimestamp().equals(that.getTimestamp()) : that.getTimestamp() != null) {
            return false;
        }
        return this.getId() != null ? this.getId().equals(that.getId()) : that.getId() == null;
    }

    public int hashCode() {
        int result = this.getUrl().hashCode();
        result = 31 * result + (this.getMethod() != null ? this.getMethod().hashCode() : 0);
        result = 31 * result + (this.getPayload() != null ? this.getPayload().hashCode() : 0);
        result = 31 * result + (this.getHeaders() != null ? this.getHeaders().hashCode() : 0);
        result = 31 * result + (this.getTimestamp() != null ? this.getTimestamp().hashCode() : 0);
        result = 31 * result + (this.getId() != null ? this.getId().hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String url;
        private RequestMethod method = RequestMethod.POST;
        private Map<String, Object> payload;
        private Map<String, String> headers = new HashMap<String, String>();
        private Date timestamp = new Date();
        private String id = RequestModel.nextId();

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(RequestMethod method) {
            this.method = method;
            return this;
        }

        public Builder payload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public RequestModel build() {
            return new RequestModel(this.url, this.method, this.payload, this.headers, this.timestamp, this.id);
        }
    }
}

