/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.connection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.emarsys.core.connection.ConnectionChangeListener;
import com.emarsys.core.connection.ConnectionState;
import com.emarsys.core.util.Assert;

public class ConnectionWatchDog {
    IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    BroadcastReceiver receiver;
    ConnectivityManager connectivityManager;
    Context context;

    public ConnectionWatchDog(Context context) {
        Assert.notNull(context, "Context must not be null!");
        this.context = context.getApplicationContext();
        this.connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
    }

    public ConnectionState getConnectionState() {
        NetworkInfo activeNetwork = this.connectivityManager.getActiveNetworkInfo();
        if (activeNetwork == null || !activeNetwork.isConnected()) {
            return ConnectionState.DISCONNECTED;
        }
        if (0 == activeNetwork.getType() || 4 == activeNetwork.getType()) {
            return ConnectionState.CONNECTED_MOBILE_DATA;
        }
        return ConnectionState.CONNECTED;
    }

    public boolean isConnected() {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public void registerReceiver(ConnectionChangeListener connectionChangeListener) {
        if (this.receiver != null) {
            throw new IllegalStateException("Register receiver cannot be called multiple times!");
        }
        this.receiver = new ConnectivityChangeReceiver(connectionChangeListener);
        this.context.registerReceiver(this.receiver, this.intentFilter);
    }

    class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        ConnectionChangeListener connectionChangeListener;

        public ConnectivityChangeReceiver(ConnectionChangeListener connectionChangeListener) {
            Assert.notNull(connectionChangeListener, "ConnectionChangeListener must not be null!");
            this.connectionChangeListener = connectionChangeListener;
        }

        public void onReceive(Context context, Intent intent) {
            this.connectionChangeListener.onConnectionChanged(ConnectionWatchDog.this.getConnectionState(), ConnectionWatchDog.this.isConnected());
        }
    }
}

