package com.emarsys.core.worker;

import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionChangeListener;
import com.emarsys.core.connection.ConnectionState;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.RestClient;
import com.emarsys.core.util.Assert;


public class DefaultWorker implements ConnectionChangeListener, Worker {

    Queue<RequestModel> queue;
    ConnectionWatchDog connectionWatchDog;
    boolean locked;
    CoreCompletionHandler coreCompletionHandler;
    RestClient restClient;

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, CoreCompletionHandler coreCompletionHandler) {
        this(queue, connectionWatchDog, coreCompletionHandler, new RestClient());
    }

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, CoreCompletionHandler coreCompletionHandler, RestClient restClient) {
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(coreCompletionHandler, "CoreCompletionHandler must not be null!");
        Assert.notNull(restClient, "Restclient must not be null!");
        this.coreCompletionHandler = coreCompletionHandler;
        this.queue = queue;
        this.connectionWatchDog = connectionWatchDog;
        this.connectionWatchDog.registerReceiver(this);
        this.restClient = restClient;
    }

    @Override
    public void lock() {
        locked = true;
    }

    @Override
    public void unlock() {
        locked = false;
    }

    @Override
    public boolean isLocked() {
        return locked;
    }

    @Override
    public void run() {
        if (!isLocked() && connectionWatchDog.isConnected() && !queue.isEmpty()) {
            lock();
            RequestModel model = queue.peek();
            restClient.execute(model, new CoreCompletionHandlerMiddleware(this, queue, coreCompletionHandler));
        }
    }

    @Override
    public void onConnectionChanged(ConnectionState connectionState, boolean isConnected) {
        if (isConnected) {
            run();
        }
    }
}