/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.worker;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionChangeListener;
import com.emarsys.core.connection.ConnectionState;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.factory.DefaultRequestTaskFactory;
import com.emarsys.core.request.factory.RequestTaskFactory;
import com.emarsys.core.util.Assert;
import com.emarsys.core.worker.CoreCompletionHandlerMiddleware;
import com.emarsys.core.worker.Worker;

public class DefaultWorker
implements ConnectionChangeListener,
Worker {
    Queue<RequestModel> queue;
    ConnectionWatchDog connectionWatchDog;
    boolean locked;
    CoreCompletionHandler coreCompletionHandler;
    RequestTaskFactory taskFactory;
    private final Handler handler = new Handler(Looper.getMainLooper());

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, CoreCompletionHandler coreCompletionHandler) {
        this(queue, connectionWatchDog, coreCompletionHandler, new DefaultRequestTaskFactory());
    }

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, CoreCompletionHandler coreCompletionHandler, RequestTaskFactory taskFactory) {
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(coreCompletionHandler, "CoreCompletionHandler must not be null!");
        this.coreCompletionHandler = coreCompletionHandler;
        this.queue = queue;
        this.connectionWatchDog = connectionWatchDog;
        this.connectionWatchDog.registerReceiver(this);
        this.taskFactory = taskFactory;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void run() {
        if (!this.isLocked()) {
            this.lock();
            this.execute();
        }
    }

    void execute() {
        if (this.connectionWatchDog.isConnected() && !this.queue.isEmpty()) {
            RequestModel model = this.queue.peek();
            this.sendRequest(model, new CoreCompletionHandlerMiddleware(this, this.queue, this.coreCompletionHandler));
        } else {
            this.unlock();
        }
    }

    void sendRequest(final RequestModel model, final CoreCompletionHandler completionHandler) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.taskFactory.create(model, completionHandler).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        } else {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultWorker.this.taskFactory.create(model, completionHandler).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
                }
            });
        }
    }

    @Override
    public void onConnectionChanged(ConnectionState connectionState, boolean isConnected) {
        if (isConnected) {
            this.run();
        }
    }
}

