/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request;

import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.util.Assert;
import com.emarsys.core.worker.DefaultWorker;
import com.emarsys.core.worker.Worker;
import java.util.HashMap;
import java.util.Map;

public class RequestManager {
    private Map<String, String> defaultHeaders;
    Queue<RequestModel> queue;
    Worker worker;

    public RequestManager(ConnectionWatchDog connectionWatchDog, Queue<RequestModel> queue, CoreCompletionHandler completionHandler) {
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(completionHandler, "CoreCompletionHandler must not be null!");
        this.defaultHeaders = new HashMap<String, String>();
        this.queue = queue;
        this.worker = new DefaultWorker(queue, connectionWatchDog, completionHandler);
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public void submit(RequestModel model) {
        Assert.notNull(model, "RequestModel must not be null!");
        this.injectDefaultHeaders(model);
        this.queue.push(model);
        this.worker.run();
    }

    void injectDefaultHeaders(RequestModel model) {
        Map<String, String> modelHeaders = model.getHeaders();
        for (Map.Entry<String, String> defaultHeader : this.defaultHeaders.entrySet()) {
            String key = defaultHeader.getKey();
            String value = defaultHeader.getValue();
            if (modelHeaders.containsKey(key)) continue;
            modelHeaders.put(key, value);
        }
    }
}

