package com.emarsys.core;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DeviceInfo {
    private final String hwid;
    private final String platform;
    private final String language;
    private final String timezone;
    private final String manufacturer;
    private final String model;
    private final String applicationVersion;
    private final String osVersion;

    public DeviceInfo(Context context){
        this.hwid = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        this.manufacturer = Build.MANUFACTURER;
        this.model = Build.MODEL;
        this.platform = "android";
        this.language = Locale.getDefault().getLanguage();

        this.timezone = new SimpleDateFormat("Z").format(Calendar.getInstance().getTime());

        this.applicationVersion = getAppliationVersion(context);

        this.osVersion = Build.VERSION.RELEASE;
    }

    private String getAppliationVersion(Context context) {
        String version = "unknown";
        try {
            version = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        } catch (PackageManager.NameNotFoundException e) {

        }
        return version;
    }

    public String getHwid() {
        return hwid;
    }

    public String getPlatform() {
        return platform;
    }

    public String getLanguage() {
        return language;
    }

    public String getTimezone() {
        return timezone;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public String getModel() {
        return model;
    }

    public String getApplicationVersion() {
        return applicationVersion;
    }

    public String getOsVersion() {
        return osVersion;
    }
}
