/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.RequestTask;
import com.emarsys.core.util.Assert;
import java.util.HashMap;
import java.util.Map;

public class RequestManager {
    private Map<String, String> defaultHeaders;
    private final Handler handler = new Handler(Looper.getMainLooper());

    public RequestManager() {
        this.defaultHeaders = new HashMap<String, String>();
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public void submit(RequestModel model, CoreCompletionHandler completionHandler) {
        Assert.notNull(model, "RequestModel must not be null!");
        Assert.notNull(completionHandler, "CoreCompletionHandler must not be null!");
        this.injectDefaultHeaders(model);
        this.sendRequest(model, completionHandler);
    }

    void injectDefaultHeaders(RequestModel model) {
        Map<String, String> modelHeaders = model.getHeaders();
        for (Map.Entry<String, String> defaultHeader : this.defaultHeaders.entrySet()) {
            String key = defaultHeader.getKey();
            String value = defaultHeader.getValue();
            if (modelHeaders.containsKey(key)) continue;
            modelHeaders.put(key, value);
        }
    }

    private void sendRequest(final RequestModel model, final CoreCompletionHandler completionHandler) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new RequestTask(model, completionHandler).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        } else {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    new RequestTask(model, completionHandler).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
                }
            });
        }
    }
}

