package com.emarsys.core.request;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;

import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.util.Assert;

import java.util.HashMap;
import java.util.Map;

public class RequestManager {

    private Map<String, String> defaultHeaders;
    private final Handler handler = new Handler(Looper.getMainLooper());

    public RequestManager(){
        defaultHeaders = new HashMap<>();
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders){
        this.defaultHeaders = defaultHeaders;
    }

    public void submit(final RequestModel model, final CoreCompletionHandler completionHandler) {
        Assert.notNull(model, "RequestModel must not be null!");
        Assert.notNull(completionHandler, "CoreCompletionHandler must not be null!");

        injectDefaultHeaders(model);
        sendRequest(model, completionHandler);
    }

    void injectDefaultHeaders(RequestModel model){
        Map<String, String> modelHeaders = model.getHeaders();
        for(Map.Entry<String, String> defaultHeader: defaultHeaders.entrySet()){
            String key = defaultHeader.getKey();
            String value = defaultHeader.getValue();

            if(!modelHeaders.containsKey(key)){
                modelHeaders.put(key, value);
            }
        }
    }

    private void sendRequest(final RequestModel model, final CoreCompletionHandler completionHandler) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new RequestTask(model, completionHandler).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR);
        } else {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    new RequestTask(model, completionHandler).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR);
                }
            });
        }
    }
}
