package com.emarsys.core.queue;

import com.emarsys.core.request.RequestModel;
import com.emarsys.core.util.Assert;

import java.util.ArrayList;
import java.util.List;

public class InMemoryQueue implements Queue<RequestModel> {

    List<RequestModel> queue = new ArrayList<>();

    @Override
    public void push(RequestModel item) {
        Assert.notNull(item, "Item must not be null!");
        queue.add(item);
    }

    @Override
    public RequestModel pop() {
        return queue.isEmpty() ? null : queue.remove(0);
    }

    @Override
    public void pushFirst(RequestModel item) {
        Assert.notNull(item, "Item must not be null!");
        queue.add(0, item);
    }
}
