/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.worker;

import android.os.Handler;
import android.os.Looper;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.database.repository.Repository;
import com.emarsys.core.database.repository.SqlSpecification;
import com.emarsys.core.request.factory.DefaultRunnableFactory;
import com.emarsys.core.request.factory.RunnableFactory;
import com.emarsys.core.request.model.RequestModel;
import com.emarsys.core.request.model.specification.FilterByRequestId;
import com.emarsys.core.response.ResponseModel;
import com.emarsys.core.util.Assert;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;
import com.emarsys.core.worker.Worker;

public class CoreCompletionHandlerMiddleware
implements CoreCompletionHandler {
    CoreCompletionHandler coreCompletionHandler;
    Repository<RequestModel, SqlSpecification> requestRepository;
    Worker worker;
    Handler coreSDKHandler;
    Handler uiHandler;
    RunnableFactory runnableFactory;

    public CoreCompletionHandlerMiddleware(Worker worker, Repository<RequestModel, SqlSpecification> requestRepository, Handler coreSDKHandler, CoreCompletionHandler coreCompletionHandler) {
        Assert.notNull(requestRepository, "RequestRepository must not be null!");
        Assert.notNull(worker, "Worker must not be null!");
        Assert.notNull(coreCompletionHandler, "CoreCompletionHandler must not be null!");
        Assert.notNull(coreSDKHandler, "coreSDKHandler must not be null!");
        this.coreCompletionHandler = coreCompletionHandler;
        this.requestRepository = requestRepository;
        this.worker = worker;
        this.coreSDKHandler = coreSDKHandler;
        this.runnableFactory = new DefaultRunnableFactory();
        this.uiHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void onSuccess(final String id, final ResponseModel responseModel) {
        EMSLogger.log(CoreTopic.OFFLINE, "Id: %s, response model: %s", id, responseModel);
        this.coreSDKHandler.post(this.runnableFactory.runnableFrom(new Runnable(){

            @Override
            public void run() {
                CoreCompletionHandlerMiddleware.this.requestRepository.remove(new FilterByRequestId(responseModel.getRequestModel()));
                CoreCompletionHandlerMiddleware.this.worker.unlock();
                CoreCompletionHandlerMiddleware.this.worker.run();
                CoreCompletionHandlerMiddleware.this.uiHandler.post(CoreCompletionHandlerMiddleware.this.runnableFactory.runnableFrom(new Runnable(){

                    @Override
                    public void run() {
                        CoreCompletionHandlerMiddleware.this.coreCompletionHandler.onSuccess(id, responseModel);
                    }
                }));
            }
        }));
    }

    @Override
    public void onError(final String id, final ResponseModel responseModel) {
        EMSLogger.log(CoreTopic.OFFLINE, "Id: %s, response model: %s", id, responseModel);
        this.coreSDKHandler.post(this.runnableFactory.runnableFrom(new Runnable(){

            @Override
            public void run() {
                if (CoreCompletionHandlerMiddleware.this.isNonRetriableError(responseModel.getStatusCode())) {
                    CoreCompletionHandlerMiddleware.this.requestRepository.remove(new FilterByRequestId(responseModel.getRequestModel()));
                    CoreCompletionHandlerMiddleware.this.worker.unlock();
                    CoreCompletionHandlerMiddleware.this.worker.run();
                } else {
                    CoreCompletionHandlerMiddleware.this.worker.unlock();
                }
                CoreCompletionHandlerMiddleware.this.uiHandler.post(CoreCompletionHandlerMiddleware.this.runnableFactory.runnableFrom(new Runnable(){

                    @Override
                    public void run() {
                        if (CoreCompletionHandlerMiddleware.this.isNonRetriableError(responseModel.getStatusCode())) {
                            CoreCompletionHandlerMiddleware.this.coreCompletionHandler.onError(id, responseModel);
                        }
                    }
                }));
            }
        }));
    }

    @Override
    public void onError(final String id, final Exception cause) {
        EMSLogger.log(CoreTopic.OFFLINE, "Id: %s, exception: %s", id, cause);
        this.coreSDKHandler.post(this.runnableFactory.runnableFrom(new Runnable(){

            @Override
            public void run() {
                CoreCompletionHandlerMiddleware.this.worker.unlock();
                CoreCompletionHandlerMiddleware.this.uiHandler.post(CoreCompletionHandlerMiddleware.this.runnableFactory.runnableFrom(new Runnable(){

                    @Override
                    public void run() {
                        CoreCompletionHandlerMiddleware.this.coreCompletionHandler.onError(id, cause);
                    }
                }));
            }
        }));
    }

    private boolean isNonRetriableError(int statusCode) {
        if (statusCode == 408) {
            return false;
        }
        return 400 <= statusCode && statusCode < 500;
    }
}

