package com.emarsys.core.request.model.specification;

import com.emarsys.core.database.repository.SqlSpecification;
import com.emarsys.core.request.model.RequestModel;

public class FilterByRequestId implements SqlSpecification {

    private final RequestModel model;

    public FilterByRequestId(RequestModel model) {
        this.model = model;
    }

    @Override
    public String getSql() {
        return "request_id=?";
    }

    @Override
    public String[] getArgs() {
        return new String[]{model.getId()};
    }

}
