/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.worker;

import android.os.Handler;
import android.os.Looper;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionChangeListener;
import com.emarsys.core.connection.ConnectionState;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestExpiredException;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.RestClient;
import com.emarsys.core.util.Assert;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;
import com.emarsys.core.worker.CoreCompletionHandlerMiddleware;
import com.emarsys.core.worker.Worker;

public class DefaultWorker
implements ConnectionChangeListener,
Worker {
    Queue<RequestModel> queue;
    ConnectionWatchDog connectionWatchDog;
    boolean locked;
    CoreCompletionHandler coreCompletionHandler;
    RestClient restClient;
    Handler coreSdkHandler;
    Handler uiHandler;

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, Handler coreSdkHandler, CoreCompletionHandler coreCompletionHandler) {
        this(queue, connectionWatchDog, coreSdkHandler, coreCompletionHandler, new RestClient());
    }

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, Handler coreSdkHandler, CoreCompletionHandler coreCompletionHandler, RestClient restClient) {
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(coreSdkHandler, "Handler must not be null!");
        Assert.notNull(coreCompletionHandler, "CoreCompletionHandler must not be null!");
        Assert.notNull(restClient, "Restclient must not be null!");
        this.coreCompletionHandler = coreCompletionHandler;
        this.queue = queue;
        this.connectionWatchDog = connectionWatchDog;
        this.connectionWatchDog.registerReceiver(this);
        this.coreSdkHandler = coreSdkHandler;
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.restClient = restClient;
    }

    @Override
    public void lock() {
        EMSLogger.log(CoreTopic.OFFLINE, "Old value: %s, new value: %s", this.locked, true);
        this.locked = true;
    }

    @Override
    public void unlock() {
        EMSLogger.log(CoreTopic.OFFLINE, "Old value: %s, new value: %s", this.locked, false);
        this.locked = false;
    }

    @Override
    public boolean isLocked() {
        EMSLogger.log(CoreTopic.OFFLINE, "Current locked status: %s", this.locked);
        return this.locked;
    }

    @Override
    public void run() {
        EMSLogger.log(CoreTopic.OFFLINE, "Entered run");
        if (!this.isLocked() && this.connectionWatchDog.isConnected() && !this.queue.isEmpty()) {
            EMSLogger.log(CoreTopic.OFFLINE, "Connection is OK and queue is not empty");
            this.lock();
            RequestModel model = this.findFirstNonExpiredModel();
            EMSLogger.log(CoreTopic.OFFLINE, "First non expired model: %s", model);
            if (model != null) {
                this.restClient.execute(model, new CoreCompletionHandlerMiddleware(this, this.queue, this.coreSdkHandler, this.coreCompletionHandler));
            } else {
                this.unlock();
            }
        }
    }

    @Override
    public void onConnectionChanged(ConnectionState connectionState, boolean isConnected) {
        if (isConnected) {
            this.run();
        }
    }

    private RequestModel findFirstNonExpiredModel() {
        while (!this.queue.isEmpty()) {
            RequestModel model = this.queue.peek();
            if (this.isExpired(model)) {
                EMSLogger.log(CoreTopic.OFFLINE, "Model expired: %s", model);
                this.handleExpiration(model);
                continue;
            }
            return model;
        }
        return null;
    }

    private boolean isExpired(RequestModel model) {
        long now = System.currentTimeMillis();
        return now - model.getTimestamp() > model.getTtl();
    }

    private void handleExpiration(final RequestModel expiredModel) {
        this.queue.pop();
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                DefaultWorker.this.coreCompletionHandler.onError(expiredModel.getId(), new RequestExpiredException("Request expired", expiredModel.getUrl().getPath()));
            }
        });
    }
}

