/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.RequestTask;
import com.emarsys.core.util.Assert;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;

public class RestClient {
    private final Handler handler = new Handler(Looper.getMainLooper());

    public void execute(RequestModel model, CoreCompletionHandler completionHandler) {
        Assert.notNull(model, "Model must not be null!");
        Assert.notNull(completionHandler, "CoreCompletionHandler must not be null!");
        EMSLogger.log(CoreTopic.NETWORKING, "Argument: %s", model);
        final RequestTask task = new RequestTask(model, completionHandler);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        } else {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
                }
            });
        }
    }
}

