/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request;

import android.os.Handler;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.factory.DefaultRunnableFactory;
import com.emarsys.core.request.factory.RunnableFactory;
import com.emarsys.core.util.Assert;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;
import com.emarsys.core.worker.DefaultWorker;
import com.emarsys.core.worker.Worker;
import java.util.HashMap;
import java.util.Map;

public class RequestManager {
    private Map<String, String> defaultHeaders;
    Queue<RequestModel> queue;
    Worker worker;
    Handler coreSDKHandler;
    RunnableFactory runnableFactory;

    protected RequestManager() {
    }

    public RequestManager(Handler coreSDKHandler, ConnectionWatchDog connectionWatchDog, Queue<RequestModel> queue, CoreCompletionHandler completionHandler) {
        Assert.notNull(coreSDKHandler, "CoreSDKHandler must not be null!");
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(completionHandler, "CoreCompletionHandler must not be null!");
        this.defaultHeaders = new HashMap<String, String>();
        this.queue = queue;
        this.coreSDKHandler = coreSDKHandler;
        this.worker = new DefaultWorker(queue, connectionWatchDog, coreSDKHandler, completionHandler);
        this.runnableFactory = new DefaultRunnableFactory();
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        EMSLogger.log(CoreTopic.NETWORKING, "Argument: %s", defaultHeaders);
        this.defaultHeaders = defaultHeaders;
    }

    public void submit(final RequestModel model) {
        Assert.notNull(model, "RequestModel must not be null!");
        EMSLogger.log(CoreTopic.NETWORKING, "Argument: %s", model);
        this.coreSDKHandler.post(this.runnableFactory.runnableFrom(new Runnable(){

            @Override
            public void run() {
                RequestManager.this.injectDefaultHeaders(model);
                RequestManager.this.queue.push(model);
                RequestManager.this.worker.run();
            }
        }));
    }

    void injectDefaultHeaders(RequestModel model) {
        Map<String, String> modelHeaders = model.getHeaders();
        for (Map.Entry<String, String> defaultHeader : this.defaultHeaders.entrySet()) {
            String key = defaultHeader.getKey();
            String value = defaultHeader.getValue();
            if (modelHeaders.containsKey(key)) continue;
            modelHeaders.put(key, value);
        }
    }
}

