/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.queue.sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.queue.sqlite.DbHelper;
import com.emarsys.core.queue.sqlite.RequestContract;
import com.emarsys.core.request.RequestMethod;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class SqliteQueue
implements Queue<RequestModel> {
    SQLiteOpenHelper helper;

    public SqliteQueue(Context context) {
        this.helper = new DbHelper(context);
    }

    @Override
    public void push(RequestModel item) {
        EMSLogger.log(CoreTopic.OFFLINE, "Argument: %s", item);
        ContentValues contentValues = new ContentValues();
        contentValues.put("request_id", item.getId());
        contentValues.put("method", item.getMethod().name());
        contentValues.put("url", item.getUrl().toString());
        contentValues.put("headers", this.serializableToBlob(item.getHeaders()));
        contentValues.put("payload", this.serializableToBlob(item.getPayload()));
        contentValues.put("timestamp", Long.valueOf(item.getTimestamp()));
        contentValues.put("ttl", Long.valueOf(item.getTtl()));
        SQLiteDatabase database = this.helper.getWritableDatabase();
        database.beginTransaction();
        database.insert("request", null, contentValues);
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    @Override
    public RequestModel pop() {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        RequestModel model = this.getFirst(db);
        if (model != null) {
            db.execSQL(String.format("DELETE FROM request WHERE request_id LIKE '%s';", model.getId()));
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        EMSLogger.log(CoreTopic.OFFLINE, "RequestModel: %s", model);
        return model;
    }

    @Override
    public RequestModel peek() {
        RequestModel model = this.getFirst(this.helper.getReadableDatabase());
        EMSLogger.log(CoreTopic.OFFLINE, "RequestModel: %s", model);
        return model;
    }

    @Override
    public boolean isEmpty() {
        Cursor cursor = this.helper.getReadableDatabase().rawQuery(RequestContract.SQL_COUNT, null);
        cursor.moveToFirst();
        int count = cursor.getInt(0);
        cursor.close();
        EMSLogger.log(CoreTopic.OFFLINE, "Queue size: %s", count);
        return count == 0;
    }

    public void setHelper(SQLiteOpenHelper helper) {
        this.helper = helper;
    }

    private RequestModel getFirst(SQLiteDatabase db) {
        RequestModel requestModel = null;
        Cursor cursor = db.rawQuery(RequestContract.SQL_SELECT_FIRST, null);
        if (cursor.getCount() != 0) {
            cursor.moveToFirst();
            String requestId = cursor.getString(cursor.getColumnIndex("request_id"));
            RequestMethod method = RequestMethod.valueOf(cursor.getString(cursor.getColumnIndex("method")));
            String url = cursor.getString(cursor.getColumnIndex("url"));
            Map headers = (Map)this.blobToSerializable(cursor.getBlob(cursor.getColumnIndex("headers")));
            Map payload = (Map)this.blobToSerializable(cursor.getBlob(cursor.getColumnIndex("payload")));
            long timeStamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
            long ttl = cursor.getLong(cursor.getColumnIndex("ttl"));
            requestModel = new RequestModel(url, method, payload, headers, timeStamp, ttl, requestId);
        }
        cursor.close();
        return requestModel;
    }

    private byte[] serializableToBlob(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while converting object to blob", e);
        }
    }

    private <T> T blobToSerializable(byte[] blob) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(blob);
            ObjectInputStream ois = new ObjectInputStream(bais);
            bais.close();
            return (T)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Exception while converting blob to object.", e);
        }
    }
}

