package com.emarsys.core.util;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

public class JsonUtils {

    public static JSONObject fromMap(Map<String, Object> map) {
        Assert.notNull(map, "Map must not be null!");
        JSONObject result = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();

                if (value instanceof Map) {
                    result.put(key, JsonUtils.fromMap((Map<String, Object>) value));
                } else {
                    result.put(key, value);
                }
            }
        } catch (JSONException je) {
            throw new IllegalArgumentException(je);
        }
        return result;
    }

}