package com.emarsys.core.request;

import android.os.Handler;

import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.factory.DefaultRunnableFactory;
import com.emarsys.core.request.factory.RunnableFactory;
import com.emarsys.core.util.Assert;
import com.emarsys.core.util.log.CoreTopic;
import com.emarsys.core.util.log.EMSLogger;
import com.emarsys.core.worker.DefaultWorker;
import com.emarsys.core.worker.Worker;

import java.util.HashMap;
import java.util.Map;

public class RequestManager {

    private Map<String, String> defaultHeaders;

    Queue<RequestModel> queue;
    Worker worker;
    Handler coreSDKHandler;
    RunnableFactory runnableFactory;

    protected RequestManager() {
    }

    public RequestManager(Handler coreSDKHandler, ConnectionWatchDog connectionWatchDog, Queue<RequestModel> queue, CoreCompletionHandler completionHandler) {
        Assert.notNull(coreSDKHandler, "CoreSDKHandler must not be null!");
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(completionHandler, "CoreCompletionHandler must not be null!");
        defaultHeaders = new HashMap<>();
        this.queue = queue;

        this.coreSDKHandler = coreSDKHandler;

        worker = new DefaultWorker(queue, connectionWatchDog, coreSDKHandler, completionHandler);

        runnableFactory = new DefaultRunnableFactory();
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        EMSLogger.log(CoreTopic.NETWORKING, "Argument: %s", defaultHeaders);
        this.defaultHeaders = defaultHeaders;
    }

    public void submit(final RequestModel model) {
        Assert.notNull(model, "RequestModel must not be null!");
        EMSLogger.log(CoreTopic.NETWORKING, "Argument: %s", model);

        coreSDKHandler.post(runnableFactory.runnableFrom(new Runnable() {
            @Override
            public void run() {
                injectDefaultHeaders(model);
                queue.push(model);
                worker.run();
            }
        }));

    }

    void injectDefaultHeaders(RequestModel model) {
        Map<String, String> modelHeaders = model.getHeaders();
        for (Map.Entry<String, String> defaultHeader : defaultHeaders.entrySet()) {
            String key = defaultHeader.getKey();
            String value = defaultHeader.getValue();

            if (!modelHeaders.containsKey(key)) {
                modelHeaders.put(key, value);
            }
        }
    }

}
