/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.worker;

import android.os.Handler;
import android.os.Looper;
import com.emarsys.core.CoreCompletionHandler;
import com.emarsys.core.connection.ConnectionChangeListener;
import com.emarsys.core.connection.ConnectionState;
import com.emarsys.core.connection.ConnectionWatchDog;
import com.emarsys.core.queue.Queue;
import com.emarsys.core.request.RequestExpiredException;
import com.emarsys.core.request.RequestModel;
import com.emarsys.core.request.RestClient;
import com.emarsys.core.util.Assert;
import com.emarsys.core.worker.CoreCompletionHandlerMiddleware;
import com.emarsys.core.worker.Worker;

public class DefaultWorker
implements ConnectionChangeListener,
Worker {
    Queue<RequestModel> queue;
    ConnectionWatchDog connectionWatchDog;
    boolean locked;
    CoreCompletionHandler coreCompletionHandler;
    RestClient restClient;
    Handler coreSdkHandler;
    Handler uiHandler;

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, Handler coreSdkHandler, CoreCompletionHandler coreCompletionHandler) {
        this(queue, connectionWatchDog, coreSdkHandler, coreCompletionHandler, new RestClient());
    }

    public DefaultWorker(Queue<RequestModel> queue, ConnectionWatchDog connectionWatchDog, Handler coreSdkHandler, CoreCompletionHandler coreCompletionHandler, RestClient restClient) {
        Assert.notNull(queue, "Queue must not be null!");
        Assert.notNull(connectionWatchDog, "ConnectionWatchDog must not be null!");
        Assert.notNull(coreSdkHandler, "Handler must not be null!");
        Assert.notNull(coreCompletionHandler, "CoreCompletionHandler must not be null!");
        Assert.notNull(restClient, "Restclient must not be null!");
        this.coreCompletionHandler = coreCompletionHandler;
        this.queue = queue;
        this.connectionWatchDog = connectionWatchDog;
        this.connectionWatchDog.registerReceiver(this);
        this.coreSdkHandler = coreSdkHandler;
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.restClient = restClient;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void run() {
        if (!this.isLocked() && this.connectionWatchDog.isConnected() && !this.queue.isEmpty()) {
            this.lock();
            RequestModel model = this.findFirstNonExpiredModel();
            if (model != null) {
                this.restClient.execute(model, new CoreCompletionHandlerMiddleware(this, this.queue, this.coreSdkHandler, this.coreCompletionHandler));
            } else {
                this.unlock();
            }
        }
    }

    @Override
    public void onConnectionChanged(ConnectionState connectionState, boolean isConnected) {
        if (isConnected) {
            this.run();
        }
    }

    private RequestModel findFirstNonExpiredModel() {
        while (!this.queue.isEmpty()) {
            RequestModel model = this.queue.peek();
            if (this.isExpired(model)) {
                this.handleExpiration(model);
                continue;
            }
            return model;
        }
        return null;
    }

    private boolean isExpired(RequestModel model) {
        long now = System.currentTimeMillis();
        return now - model.getTimestamp() > model.getTtl();
    }

    private void handleExpiration(final RequestModel expiredModel) {
        this.queue.pop();
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                DefaultWorker.this.coreCompletionHandler.onError(expiredModel.getId(), new RequestExpiredException("Request expired", expiredModel.getUrl().getPath()));
            }
        });
    }
}

