/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core.request;

import com.emarsys.core.request.RequestMethod;
import com.emarsys.core.util.Assert;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class RequestModel
implements Serializable {
    private URL url;
    private RequestMethod method;
    private Map<String, Object> payload;
    private Map<String, String> headers;
    private long timestamp;
    private long ttl;
    private String id;

    public RequestModel(String url, RequestMethod method, Map<String, Object> payload, Map<String, String> headers, long timestamp, long ttl, String id) {
        Assert.notNull(url, "Url must not be null!");
        Assert.notNull((Object)method, "Method must not be null!");
        Assert.notNull(headers, "Headers must not be null!");
        Assert.notNull(id, "Id must not be null!");
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException(mue);
        }
        this.method = method;
        this.payload = payload;
        this.headers = headers;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.id = id;
    }

    public static String nextId() {
        return UUID.randomUUID().toString();
    }

    public URL getUrl() {
        return this.url;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTtl() {
        return this.ttl;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestModel that = (RequestModel)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.ttl != that.ttl) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.ttl ^ this.ttl >>> 32);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String url;
        private RequestMethod method = RequestMethod.POST;
        private Map<String, Object> payload;
        private Map<String, String> headers = new HashMap<String, String>();
        private long timestamp = System.currentTimeMillis();
        private long ttl = Long.MAX_VALUE;
        private String id = RequestModel.nextId();

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(RequestMethod method) {
            this.method = method;
            return this;
        }

        public Builder payload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder ttl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public RequestModel build() {
            return new RequestModel(this.url, this.method, this.payload, this.headers, this.timestamp, this.ttl, this.id);
        }
    }
}

