/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.core;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import com.emarsys.core.util.Assert;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DeviceInfo {
    static final String UNKNOWN_VERSION_NAME = "unknown";
    private final String hwid;
    private final String platform;
    private final String language;
    private final String timezone;
    private final String manufacturer;
    private final String model;
    private final String applicationVersion;
    private final String osVersion;

    public DeviceInfo(Context context) {
        Assert.notNull(context, "Context must not be null!");
        this.hwid = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        this.manufacturer = Build.MANUFACTURER;
        this.model = Build.MODEL;
        this.platform = "android";
        this.language = Locale.getDefault().getLanguage();
        this.timezone = new SimpleDateFormat("Z", Locale.ENGLISH).format(Calendar.getInstance().getTime());
        this.applicationVersion = this.getAppliationVersion(context);
        this.osVersion = Build.VERSION.RELEASE;
    }

    private String getAppliationVersion(Context context) {
        String version = null;
        try {
            version = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (version == null) {
            version = UNKNOWN_VERSION_NAME;
        }
        return version;
    }

    public String getHwid() {
        return this.hwid;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }
}

