/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.uuid;

import java.util.Arrays;
import java.util.UUID;

public class FastUUID {
    private static final boolean USE_JDK_UUID_TO_STRING;
    private static final int UUID_STRING_LENGTH = 36;
    private static final char[] HEX_DIGITS;
    private static final long[] HEX_VALUES;

    private FastUUID() {
    }

    public static UUID parseUUID(CharSequence uuidSequence) {
        if (uuidSequence.length() != 36 || uuidSequence.charAt(8) != '-' || uuidSequence.charAt(13) != '-' || uuidSequence.charAt(18) != '-' || uuidSequence.charAt(23) != '-') {
            throw new IllegalArgumentException("Illegal UUID string: " + uuidSequence);
        }
        long mostSignificantBits = FastUUID.getHexValueForChar(uuidSequence.charAt(0)) << 60;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(1)) << 56;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(2)) << 52;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(3)) << 48;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(4)) << 44;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(5)) << 40;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(6)) << 36;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(7)) << 32;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(9)) << 28;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(10)) << 24;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(11)) << 20;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(12)) << 16;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(14)) << 12;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(15)) << 8;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(16)) << 4;
        mostSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(17));
        long leastSignificantBits = FastUUID.getHexValueForChar(uuidSequence.charAt(19)) << 60;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(20)) << 56;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(21)) << 52;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(22)) << 48;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(24)) << 44;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(25)) << 40;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(26)) << 36;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(27)) << 32;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(28)) << 28;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(29)) << 24;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(30)) << 20;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(31)) << 16;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(32)) << 12;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(33)) << 8;
        leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(34)) << 4;
        return new UUID(mostSignificantBits, leastSignificantBits |= FastUUID.getHexValueForChar(uuidSequence.charAt(35)));
    }

    public static String toString(UUID uuid) {
        if (USE_JDK_UUID_TO_STRING) {
            return uuid.toString();
        }
        long mostSignificantBits = uuid.getMostSignificantBits();
        long leastSignificantBits = uuid.getLeastSignificantBits();
        char[] uuidChars = new char[]{HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000000L) >>> 48)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000L) >>> 32)], '-', HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000L) >>> 16)], '-', HEX_DIGITS[(int)((mostSignificantBits & 0xF000L) >>> 12)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00L) >>> 8)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0L) >>> 4)], HEX_DIGITS[(int)(mostSignificantBits & 0xFL)], '-', HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000000L) >>> 48)], '-', HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000L) >>> 32)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000L) >>> 16)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000L) >>> 12)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00L) >>> 8)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0L) >>> 4)], HEX_DIGITS[(int)(leastSignificantBits & 0xFL)]};
        return new String(uuidChars);
    }

    static long getHexValueForChar(char c) {
        try {
            if (HEX_VALUES[c] < 0L) {
                throw new IllegalArgumentException("Illegal hexadecimal digit: " + c);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Illegal hexadecimal digit: " + c);
        }
        return HEX_VALUES[c];
    }

    static {
        int majorVersion = 0;
        try {
            majorVersion = Integer.parseInt(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        USE_JDK_UUID_TO_STRING = majorVersion >= 9;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_VALUES = new long[128];
        Arrays.fill(HEX_VALUES, -1L);
        FastUUID.HEX_VALUES[48] = 0L;
        FastUUID.HEX_VALUES[49] = 1L;
        FastUUID.HEX_VALUES[50] = 2L;
        FastUUID.HEX_VALUES[51] = 3L;
        FastUUID.HEX_VALUES[52] = 4L;
        FastUUID.HEX_VALUES[53] = 5L;
        FastUUID.HEX_VALUES[54] = 6L;
        FastUUID.HEX_VALUES[55] = 7L;
        FastUUID.HEX_VALUES[56] = 8L;
        FastUUID.HEX_VALUES[57] = 9L;
        FastUUID.HEX_VALUES[97] = 10L;
        FastUUID.HEX_VALUES[98] = 11L;
        FastUUID.HEX_VALUES[99] = 12L;
        FastUUID.HEX_VALUES[100] = 13L;
        FastUUID.HEX_VALUES[101] = 14L;
        FastUUID.HEX_VALUES[102] = 15L;
        FastUUID.HEX_VALUES[65] = 10L;
        FastUUID.HEX_VALUES[66] = 11L;
        FastUUID.HEX_VALUES[67] = 12L;
        FastUUID.HEX_VALUES[68] = 13L;
        FastUUID.HEX_VALUES[69] = 14L;
        FastUUID.HEX_VALUES[70] = 15L;
    }
}

