/*
 * Decompiled with CFR 0.152.
 */
package com.ea.async.instrumentation;

import com.ea.async.instrumentation.Transformer;
import com.ea.async.shaded.org.objectweb.asm.ClassReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class Main {
    private boolean verbose;
    private List<Path> fileList;
    private Path outputDirectory;
    private ClassLoader classLoader = this.getClass().getClassLoader();

    public static void main(String[] args) throws IOException {
        int ret = new Main().doMain(args);
        if (ret != 0) {
            System.exit(-1);
        }
    }

    public int doMain(String[] args) throws IOException {
        this.outputDirectory = null;
        this.fileList = new ArrayList<Path>();
        if (args.length == 0) {
            this.printUsage();
            return 0;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--help".equals(arg)) {
                this.printUsage();
                continue;
            }
            if ("-verbose".equals(arg)) {
                this.verbose = true;
                continue;
            }
            if ("-d".equals(arg)) {
                if (i + 1 == args.length) {
                    this.error("Invalid usage of the -d option");
                    return 1;
                }
                this.outputDirectory = Paths.get(args[++i], new String[0]);
                continue;
            }
            Path path = Paths.get(arg, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".class")).forEach(this.fileList::add);
                continue;
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                this.fileList.add(path);
                continue;
            }
            this.error("Invalid argument or file: " + arg);
            return 1;
        }
        return this.transform() >= 0 ? 0 : 1;
    }

    public int transform() throws IOException {
        Transformer transformer = new Transformer();
        transformer.setErrorListener(System.err::println);
        boolean error = false;
        int count = 0;
        Path outputDir = this.getOutputDirectory();
        for (Path path : this.fileList) {
            byte[] bytes = null;
            try (FileInputStream in = new FileInputStream(path.toFile());){
                bytes = transformer.instrument(this.classLoader, in);
            }
            catch (Exception e) {
                this.error("Error instrumenting " + path, e);
                error = true;
            }
            if (bytes == null) continue;
            if (this.verbose) {
                this.info("instrumented: " + path);
            }
            if (outputDir != null) {
                Path outPath = outputDir.resolve(new ClassReader(bytes).getClassName() + ".class");
                Path outParent = outPath.getParent();
                if (!Files.exists(outParent, new LinkOption[0])) {
                    Files.createDirectories(outParent, new FileAttribute[0]);
                }
                Files.write(outPath, bytes, new OpenOption[0]);
            } else {
                Files.write(path, bytes, new OpenOption[0]);
            }
            ++count;
        }
        return error ? -1 : count;
    }

    private void error(String msg, Exception e) {
        System.err.println(msg);
        e.printStackTrace();
    }

    protected void error(String msg) {
        System.err.println(msg);
    }

    protected void info(String msg) {
        System.err.println(msg);
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" java -cp project-class-path -jar ea-async.jar -d output-directory file1 input-dir1 input-dir2");
        System.out.println("options:");
        System.out.println("-d directory");
        System.out.println("   Set the destination directory for class files. ");
        System.out.println("   If not specified the original files will be modified in place");
        System.out.println("-help");
        System.out.println("   Shows this help. ");
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public List<Path> getFileList() {
        return this.fileList;
    }

    public void setFileList(List<Path> fileList) {
        this.fileList = fileList;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

