/*
 * Decompiled with CFR 0.152.
 */
package com.ea.agentloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Locale;

public class ClassPathUtils {
    public static URL getClassPathFor(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        try {
            URL url = ClassPathUtils.getClassFile(clazz);
            String urlString = url.toString();
            int endIndex = urlString.indexOf("!");
            if (endIndex > 0) {
                int beginIndex = urlString.toLowerCase(Locale.ENGLISH).lastIndexOf("file:/");
                if (beginIndex >= 0) {
                    return new URL(urlString.substring(beginIndex, endIndex));
                }
                beginIndex = urlString.lastIndexOf("[a-zA-Z]+://");
                if (beginIndex > 0) {
                    return new URL(urlString.substring(beginIndex, endIndex));
                }
            } else {
                File dir = new File(url.toURI()).getParentFile();
                if (clazz.getPackage() != null) {
                    String pn = clazz.getPackage().getName();
                    int i = pn.indexOf(46);
                    while (i >= 0) {
                        dir = dir.getParentFile();
                        i = pn.indexOf(46, i + 1);
                    }
                    dir = dir.getParentFile();
                }
                return dir.toURI().toURL();
            }
            throw new RuntimeException("Error locating classpath entry for: " + clazz.getName() + " url: " + url);
        }
        catch (Exception e) {
            throw new RuntimeException("Error locating classpath entry for: " + clazz.getName(), e);
        }
    }

    public static URL getClassFile(Class<?> clazz) {
        int idx = clazz.getName().lastIndexOf(46);
        String fileName = (idx >= 0 ? clazz.getName().substring(idx + 1) : clazz.getName()) + ".class";
        return clazz.getResource(fileName);
    }

    public static void appendToSystemPath(URL path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)systemClassLoader, path);
        }
        catch (Exception ex) {
            throw new RuntimeException("Add URL failed: " + path, ex);
        }
    }

    static byte[] toByteArray(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[Math.max(1024, input.available())];
        int offset = 0;
        while (-1 != (bytesRead = input.read(buffer, offset, buffer.length - offset))) {
            if ((offset += bytesRead) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length + Math.max(input.available(), buffer.length >> 1));
        }
        return offset == buffer.length ? buffer : Arrays.copyOf(buffer, offset);
    }

    public static Class<?> defineClass(ClassLoader loader, InputStream inputStream) {
        try {
            byte[] bytes = ClassPathUtils.toByteArray(inputStream);
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
            return (Class)defineClassMethod.invoke((Object)loader, null, bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

