/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.gradle.tasks.PackageApplication;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.SigningConfig;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.dynatrace.tools.android.AndroidPluginVersion;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class AutoInstrumentTask
extends ConventionTask {
    private File apkFile;
    private String applicationId;
    private String environmentId;
    private String cluster;
    private String startupPath;
    private Map<String, String> agentProperties;
    private SigningConfig signingConfig;
    private File apkitDir;
    private File outputFile;
    private AndroidPluginVersion androidPluginVersion = AndroidPluginVersion.VERSION_1_5;
    private PackageApplication packageTask;

    @TaskAction
    public void instrument() {
        block43: {
            boolean isAppMon = this.getEnvironmentId() == null;
            Properties tmpProperties = new Properties();
            tmpProperties.putAll(this.getAgentProperties());
            if (this.getApplicationId() != null) {
                tmpProperties.put("DTXApplicationID", this.getApplicationId());
            }
            if (!isAppMon) {
                if (this.getEnvironmentId() != null) {
                    tmpProperties.put("DTXAgentEnvironment", this.getEnvironmentId());
                }
                if (this.getCluster() != null) {
                    tmpProperties.put("DTXClusterURL", this.getCluster());
                }
            } else if (this.getStartupPath() != null) {
                tmpProperties.put("DTXAgentStartupPath", this.getStartupPath());
            }
            File propertyFile = new File(this.getTemporaryDir(), "instrument.properties");
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(propertyFile));){
                tmpProperties.store(out, "Autogenerated properties");
            }
            catch (IOException ex) {
                throw new GradleException("Exception writing instrument.properties", (Throwable)ex);
            }
            String executableName = System.getProperty("os.name").toLowerCase().contains("windows") ? "instrument.cmd" : "instrument.sh";
            File instrumentExecutable = this.getProject().fileTree((Object)this.getApkitDir()).filter(file -> executableName.equalsIgnoreCase(file.getName())).getSingleFile();
            instrumentExecutable.setExecutable(true);
            if (this.getApkFile() == null || !this.getApkFile().getName().endsWith(".apk")) {
                throw new GradleException("Task input contains an invalid apk file: " + this.getApkFile());
            }
            String dirName = this.getApkFile().getName().substring(0, this.getApkFile().getName().lastIndexOf(".apk"));
            File instrumentDist = new File(this.getApkFile().getParentFile(), dirName + "/dist");
            File instrumentDirectory = new File(this.getApkFile().getParentFile(), dirName);
            File instrumentedAPK = new File(instrumentDist, this.getApkFile().getName());
            if (instrumentDirectory.exists()) {
                this.getProject().delete(new Object[]{instrumentDirectory});
            }
            this.getProject().exec(execSpec -> {
                execSpec.setExecutable((Object)instrumentExecutable);
                execSpec.setWorkingDir((Object)this.getTemporaryDir());
                execSpec.args(new Object[]{"apk=" + this.getApkFile().getAbsolutePath(), "prop=" + propertyFile.getAbsolutePath()});
            });
            if (!instrumentedAPK.exists()) {
                throw new IllegalStateException("auto-instrumentation failed");
            }
            try {
                Object noCompressPredicate;
                Object nativeLibrariesPackagingMode;
                boolean v2SigningEnabled;
                boolean v1SigningEnabled;
                X509Certificate certificate;
                PrivateKey key;
                String methodBuilderClass = this.androidPluginVersion.isOlderThan(AndroidPluginVersion.VERSION_3_1) ? "com.android.build.gradle.internal.tasks.BaseTask" : "com.android.build.gradle.internal.tasks.AndroidBuilderTask";
                Method methodBuilder = Class.forName(methodBuilderClass).getDeclaredMethod("getBuilder", new Class[0]);
                methodBuilder.setAccessible(true);
                AndroidBuilder androidBuilder = (AndroidBuilder)methodBuilder.invoke((Object)this.packageTask, new Object[0]);
                if (this.androidPluginVersion == AndroidPluginVersion.VERSION_1_5) {
                    Method methodSignApk = AndroidBuilder.class.getDeclaredMethod("signApk", File.class, SigningConfig.class, File.class);
                    methodSignApk.setAccessible(true);
                    methodSignApk.invoke((Object)androidBuilder, instrumentedAPK, this.getSigningConfig(), this.getOutputFile());
                    break block43;
                }
                String mainFileName = this.getApkFile().getAbsolutePath();
                String origFileName = mainFileName.substring(0, mainFileName.length() - 4) + "_uninstrumented.apk";
                this.getApkFile().renameTo(new File(origFileName));
                Class<?> classPackageAndroidArtifact = Class.forName("com.android.build.gradle.tasks.PackageAndroidArtifact");
                Method methodMinSdk = classPackageAndroidArtifact.getDeclaredMethod("getMinSdkVersion", new Class[0]);
                methodMinSdk.setAccessible(true);
                int minSdkVersion = (Integer)methodMinSdk.invoke((Object)this.packageTask, new Object[0]);
                Method methodDebugBuild = classPackageAndroidArtifact.getDeclaredMethod("getDebugBuild", new Class[0]);
                methodDebugBuild.setAccessible(true);
                boolean debugBuild = (Boolean)methodDebugBuild.invoke((Object)this.packageTask, new Object[0]);
                Method methodCreatedBy = AndroidBuilder.class.getDeclaredMethod("getCreatedBy", new Class[0]);
                methodCreatedBy.setAccessible(true);
                String createdBy = (String)methodCreatedBy.invoke((Object)androidBuilder, new Object[0]);
                if (this.signingConfig != null && this.signingConfig.isSigningReady()) {
                    CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)this.signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)this.signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyAlias())));
                    key = certificateInfo.getKey();
                    certificate = certificateInfo.getCertificate();
                    Method methodIsV1 = SigningConfig.class.getMethod("isV1SigningEnabled", new Class[0]);
                    methodIsV1.setAccessible(true);
                    Method methodIsV2 = SigningConfig.class.getMethod("isV2SigningEnabled", new Class[0]);
                    methodIsV2.setAccessible(true);
                    v1SigningEnabled = (Boolean)methodIsV1.invoke((Object)this.signingConfig, new Object[0]);
                    v2SigningEnabled = (Boolean)methodIsV2.invoke((Object)this.signingConfig, new Object[0]);
                } else {
                    key = null;
                    certificate = null;
                    v1SigningEnabled = false;
                    v2SigningEnabled = false;
                }
                String packageName = this.androidPluginVersion == AndroidPluginVersion.VERSION_2_2 ? "com.android.builder.packaging." : "com.android.apkzlib.zfile.";
                Class<?> classNativeLibrariesPackagingMode = Class.forName(packageName + "NativeLibrariesPackagingMode");
                Class<?> classCreationData = Class.forName(packageName + "ApkCreatorFactory$CreationData");
                Constructor<?> constructor = classCreationData.getDeclaredConstructor(File.class, PrivateKey.class, X509Certificate.class, Boolean.TYPE, Boolean.TYPE, String.class, String.class, Integer.TYPE, classNativeLibrariesPackagingMode, Predicate.class);
                Class<?> classPackagingUtils = Class.forName("com.android.builder.packaging.PackagingUtils");
                Method methodNativeLibraries = classPackagingUtils.getDeclaredMethod("getNativeLibrariesLibrariesPackagingMode", File.class);
                methodNativeLibraries.setAccessible(true);
                if (this.androidPluginVersion == AndroidPluginVersion.VERSION_3_0 || this.androidPluginVersion == AndroidPluginVersion.VERSION_3_1) {
                    nativeLibrariesPackagingMode = classNativeLibrariesPackagingMode.getEnumConstants()[0];
                    noCompressPredicate = s -> false;
                } else {
                    Field fieldManifest = classPackageAndroidArtifact.getDeclaredField("manifest");
                    fieldManifest.setAccessible(true);
                    File manifest = (File)fieldManifest.get(this.packageTask);
                    nativeLibrariesPackagingMode = methodNativeLibraries.invoke(null, manifest);
                    Method methodGetNoCompressPredicate = classPackageAndroidArtifact.getDeclaredMethod("getNoCompressPredicate", new Class[0]);
                    methodGetNoCompressPredicate.setAccessible(true);
                    noCompressPredicate = this.androidPluginVersion == AndroidPluginVersion.VERSION_2_3 ? methodGetNoCompressPredicate.invoke((Object)this.packageTask, new Object[0]) : arg_0 -> ((com.google.common.base.Predicate)((com.google.common.base.Predicate)methodGetNoCompressPredicate.invoke((Object)this.packageTask, new Object[0]))).apply(arg_0);
                }
                Object creationData = constructor.newInstance(this.getOutputFile(), key, certificate, v1SigningEnabled, v2SigningEnabled, null, createdBy, minSdkVersion, nativeLibrariesPackagingMode, noCompressPredicate);
                Class<?> classApkCreatorFactories = Class.forName("com.android.build.gradle.internal.packaging.ApkCreatorFactories");
                Method methodFromProjectProperties = classApkCreatorFactories.getDeclaredMethod("fromProjectProperties", Project.class, Boolean.TYPE);
                methodFromProjectProperties.setAccessible(true);
                Object factory = methodFromProjectProperties.invoke(null, this.getProject(), debugBuild);
                Class<?> classApkCreatorFactory = Class.forName(packageName + "ApkCreatorFactory");
                Method methodMake = classApkCreatorFactory.getDeclaredMethod("make", classCreationData);
                methodMake.setAccessible(true);
                try (Closeable creator = (Closeable)methodMake.invoke(factory, creationData);){
                    Method methodWriteZip = creator.getClass().getDeclaredMethod("writeZip", File.class, Function.class, Predicate.class);
                    methodWriteZip.setAccessible(true);
                    methodWriteZip.invoke((Object)creator, instrumentedAPK, null, null);
                }
                this.getProject().copy(copy -> {
                    copy.from(new Object[]{this.getOutputFile()});
                    copy.into((Object)this.getApkFile().getParentFile());
                });
            }
            catch (Exception ex) {
                throw new GradleException("Failed to sign apk", (Throwable)ex);
            }
        }
    }

    @InputFile
    public File getApkFile() {
        return this.apkFile;
    }

    public void setApkFile(File apkFile) {
        this.apkFile = apkFile;
    }

    @Input
    @Optional
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Input
    @Optional
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Input
    @Optional
    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Input
    @Optional
    public String getStartupPath() {
        return this.startupPath;
    }

    public void setStartupPath(String startupPath) {
        this.startupPath = startupPath;
    }

    @Input
    public Map<String, String> getAgentProperties() {
        return this.agentProperties;
    }

    public void setAgentProperties(Map<String, String> agentProperties) {
        this.agentProperties = agentProperties;
    }

    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Internal
    public File getApkitDir() {
        return this.apkitDir;
    }

    @Optional
    @InputFiles
    FileTree getApkitFiles() {
        if (this.apkitDir != null) {
            return this.getProject().fileTree((Object)this.apkitDir);
        }
        return null;
    }

    public void setApkitDir(File apkitDir) {
        this.apkitDir = apkitDir;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Input
    public AndroidPluginVersion getAndroidPluginVersion() {
        return this.androidPluginVersion;
    }

    public void setAndroidPluginVersion(AndroidPluginVersion androidPluginVersion) {
        this.androidPluginVersion = androidPluginVersion;
    }

    public PackageApplication getPackageTask() {
        return this.packageTask;
    }

    public void setPackageTask(PackageApplication packageTask) {
        this.packageTask = packageTask;
    }
}

