/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.WorkspaceItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides properties that describe the contents of a workspace folder.")
public class WorkspaceFolderContents {
    @JsonProperty(value="endPosition")
    private String endPosition = null;
    @JsonProperty(value="folder")
    private WorkspaceItem folder = null;
    @JsonProperty(value="items")
    private List<WorkspaceItem> items = null;
    @JsonProperty(value="parentFolders")
    private List<WorkspaceItem> parentFolders = null;
    @JsonProperty(value="resultSetSize")
    private String resultSetSize = null;
    @JsonProperty(value="startPosition")
    private String startPosition = null;
    @JsonProperty(value="totalSetSize")
    private String totalSetSize = null;
    @JsonProperty(value="workspaceId")
    private String workspaceId = null;

    public WorkspaceFolderContents endPosition(String endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @ApiModelProperty(value="The last position in the result set. ")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    public WorkspaceFolderContents folder(WorkspaceItem folder) {
        this.folder = folder;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkspaceItem getFolder() {
        return this.folder;
    }

    public void setFolder(WorkspaceItem folder) {
        this.folder = folder;
    }

    public WorkspaceFolderContents items(List<WorkspaceItem> items) {
        this.items = items;
        return this;
    }

    public WorkspaceFolderContents addItemsItem(WorkspaceItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<WorkspaceItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<WorkspaceItem> getItems() {
        return this.items;
    }

    public void setItems(List<WorkspaceItem> items) {
        this.items = items;
    }

    public WorkspaceFolderContents parentFolders(List<WorkspaceItem> parentFolders) {
        this.parentFolders = parentFolders;
        return this;
    }

    public WorkspaceFolderContents addParentFoldersItem(WorkspaceItem parentFoldersItem) {
        if (this.parentFolders == null) {
            this.parentFolders = new ArrayList<WorkspaceItem>();
        }
        this.parentFolders.add(parentFoldersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<WorkspaceItem> getParentFolders() {
        return this.parentFolders;
    }

    public void setParentFolders(List<WorkspaceItem> parentFolders) {
        this.parentFolders = parentFolders;
    }

    public WorkspaceFolderContents resultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
        return this;
    }

    @ApiModelProperty(value="The number of results returned in this response. ")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public WorkspaceFolderContents startPosition(String startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @ApiModelProperty(value="Starting position of the current result set.")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public WorkspaceFolderContents totalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
        return this;
    }

    @ApiModelProperty(value="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public WorkspaceFolderContents workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @ApiModelProperty(value="The id of the workspace, always populated.")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceFolderContents workspaceFolderContents = (WorkspaceFolderContents)o;
        return Objects.equals(this.endPosition, workspaceFolderContents.endPosition) && Objects.equals(this.folder, workspaceFolderContents.folder) && Objects.equals(this.items, workspaceFolderContents.items) && Objects.equals(this.parentFolders, workspaceFolderContents.parentFolders) && Objects.equals(this.resultSetSize, workspaceFolderContents.resultSetSize) && Objects.equals(this.startPosition, workspaceFolderContents.startPosition) && Objects.equals(this.totalSetSize, workspaceFolderContents.totalSetSize) && Objects.equals(this.workspaceId, workspaceFolderContents.workspaceId);
    }

    public int hashCode() {
        return Objects.hash(this.endPosition, this.folder, this.items, this.parentFolders, this.resultSetSize, this.startPosition, this.totalSetSize, this.workspaceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkspaceFolderContents {\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("    folder: ").append(this.toIndentedString(this.folder)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    parentFolders: ").append(this.toIndentedString(this.parentFolders)).append("\n");
        sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

