/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.AccountBillingPlanResponse;
import com.docusign.esign.model.BillingInvoice;
import com.docusign.esign.model.BillingInvoicesResponse;
import com.docusign.esign.model.BillingInvoicesSummary;
import com.docusign.esign.model.BillingPaymentItem;
import com.docusign.esign.model.BillingPaymentRequest;
import com.docusign.esign.model.BillingPaymentResponse;
import com.docusign.esign.model.BillingPaymentsResponse;
import com.docusign.esign.model.BillingPlanInformation;
import com.docusign.esign.model.BillingPlanResponse;
import com.docusign.esign.model.BillingPlanUpdateResponse;
import com.docusign.esign.model.BillingPlansResponse;
import com.docusign.esign.model.CreditCardInformation;
import com.docusign.esign.model.DowngradRequestBillingInfoResponse;
import com.docusign.esign.model.DowngradeBillingPlanInformation;
import com.docusign.esign.model.DowngradePlanUpdateResponse;
import com.docusign.esign.model.PurchasedEnvelopesInformation;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class BillingApi {
    private ApiClient apiClient;

    public BillingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BillingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BillingPlanResponse getBillingPlan(String billingPlanId) throws ApiException {
        String localVarPostBody = "{}";
        if (billingPlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'billingPlanId' when calling getBillingPlan");
        }
        String localVarPath = "/v2.1/billing_plans/{billingPlanId}".replaceAll("\\{billingPlanId\\}", this.apiClient.escapeString(billingPlanId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPlanResponse> localVarReturnType = new GenericType<BillingPlanResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreditCardInformation getCreditCardInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getCreditCardInfo");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_plan/credit_card".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CreditCardInformation> localVarReturnType = new GenericType<CreditCardInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DowngradRequestBillingInfoResponse getDowngradeRequestBillingInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDowngradeRequestBillingInfo");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_plan/downgrade".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DowngradRequestBillingInfoResponse> localVarReturnType = new GenericType<DowngradRequestBillingInfoResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingInvoice getInvoice(String accountId, String invoiceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getInvoice");
        }
        if (invoiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'invoiceId' when calling getInvoice");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_invoices/{invoiceId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{invoiceId\\}", this.apiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingInvoice> localVarReturnType = new GenericType<BillingInvoice>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingPaymentItem getPayment(String accountId, String paymentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPayment");
        }
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getPayment");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_payments/{paymentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{paymentId\\}", this.apiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPaymentItem> localVarReturnType = new GenericType<BillingPaymentItem>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AccountBillingPlanResponse getPlan(String accountId) throws ApiException {
        return this.getPlan(accountId, null);
    }

    public AccountBillingPlanResponse getPlan(String accountId, GetPlanOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPlan");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_plan".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_credit_card_information", options.includeCreditCardInformation));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_successor_plans", options.includeSuccessorPlans));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<AccountBillingPlanResponse> localVarReturnType = new GenericType<AccountBillingPlanResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingPlansResponse listBillingPlans() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/billing_plans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPlansResponse> localVarReturnType = new GenericType<BillingPlansResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingInvoicesResponse listInvoices(String accountId) throws ApiException {
        return this.listInvoices(accountId, null);
    }

    public BillingInvoicesResponse listInvoices(String accountId, ListInvoicesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listInvoices");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_invoices".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingInvoicesResponse> localVarReturnType = new GenericType<BillingInvoicesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingInvoicesSummary listInvoicesPastDue(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listInvoicesPastDue");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_invoices_past_due".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingInvoicesSummary> localVarReturnType = new GenericType<BillingInvoicesSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingPaymentsResponse listPayments(String accountId) throws ApiException {
        return this.listPayments(accountId, null);
    }

    public BillingPaymentsResponse listPayments(String accountId, ListPaymentsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listPayments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_payments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPaymentsResponse> localVarReturnType = new GenericType<BillingPaymentsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingPaymentResponse makePayment(String accountId, BillingPaymentRequest billingPaymentRequest) throws ApiException {
        BillingPaymentRequest localVarPostBody = billingPaymentRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling makePayment");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_payments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPaymentResponse> localVarReturnType = new GenericType<BillingPaymentResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void purchaseEnvelopes(String accountId, PurchasedEnvelopesInformation purchasedEnvelopesInformation) throws ApiException {
        PurchasedEnvelopesInformation localVarPostBody = purchasedEnvelopesInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling purchaseEnvelopes");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_plan/purchased_envelopes".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public DowngradePlanUpdateResponse updateDowngradeAccountBillingPlan(String accountId, DowngradeBillingPlanInformation downgradeBillingPlanInformation) throws ApiException {
        DowngradeBillingPlanInformation localVarPostBody = downgradeBillingPlanInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDowngradeAccountBillingPlan");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_plan/downgrade".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DowngradePlanUpdateResponse> localVarReturnType = new GenericType<DowngradePlanUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BillingPlanUpdateResponse updatePlan(String accountId, BillingPlanInformation billingPlanInformation) throws ApiException {
        return this.updatePlan(accountId, billingPlanInformation, null);
    }

    public BillingPlanUpdateResponse updatePlan(String accountId, BillingPlanInformation billingPlanInformation, UpdatePlanOptions options) throws ApiException {
        BillingPlanInformation localVarPostBody = billingPlanInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updatePlan");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/billing_plan".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preview_billing_plan", options.previewBillingPlan));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPlanUpdateResponse> localVarReturnType = new GenericType<BillingPlanUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class UpdatePlanOptions {
        private String previewBillingPlan = null;

        public void setPreviewBillingPlan(String previewBillingPlan) {
            this.previewBillingPlan = previewBillingPlan;
        }

        public String getPreviewBillingPlan() {
            return this.previewBillingPlan;
        }
    }

    public class ListPaymentsOptions {
        private String fromDate = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class ListInvoicesOptions {
        private String fromDate = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetPlanOptions {
        private String includeCreditCardInformation = null;
        private String includeMetadata = null;
        private String includeSuccessorPlans = null;

        public void setIncludeCreditCardInformation(String includeCreditCardInformation) {
            this.includeCreditCardInformation = includeCreditCardInformation;
        }

        public String getIncludeCreditCardInformation() {
            return this.includeCreditCardInformation;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeSuccessorPlans(String includeSuccessorPlans) {
            this.includeSuccessorPlans = includeSuccessorPlans;
        }

        public String getIncludeSuccessorPlans() {
            return this.includeSuccessorPlans;
        }
    }
}

