/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion;

import com.documents4j.api.DocumentType;
import com.documents4j.conversion.ConverterRegistry;
import com.documents4j.conversion.ExternalConverterDiscovery;
import com.documents4j.conversion.IConversionManager;
import com.documents4j.conversion.IExternalConverter;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class DefaultConversionManager
implements IConversionManager {
    private final ConverterRegistry converterRegistry;

    public DefaultConversionManager(File baseFolder, long processTimeout, TimeUnit timeUnit, Map<Class<? extends IExternalConverter>, Boolean> externalConverterRegistration) {
        this.converterRegistry = new ConverterRegistry(ExternalConverterDiscovery.loadConfiguration(baseFolder, processTimeout, timeUnit, externalConverterRegistration));
    }

    @Override
    public Future<Boolean> startConversion(File source, DocumentType sourceFormat, File target, DocumentType targetFormat) {
        return this.converterRegistry.lookup(sourceFormat, targetFormat).startConversion(source, sourceFormat, target, targetFormat);
    }

    @Override
    public Map<DocumentType, Set<DocumentType>> getSupportedConversions() {
        return this.converterRegistry.getSupportedConversions();
    }

    @Override
    public boolean isOperational() {
        return this.converterRegistry.isOperational();
    }

    @Override
    public void shutDown() {
        this.converterRegistry.shutDown();
    }
}

