/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion;

import com.documents4j.util.Reaction;
import com.google.common.base.Objects;

public enum ExternalConverterScriptResult {
    CONVERSION_SUCCESSFUL(2, Reaction.with((boolean)true)),
    CONVERTER_INTERACTION_SUCCESSFUL(3, Reaction.with((boolean)true)),
    ILLEGAL_INPUT(-2, Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConversionInputExceptionBuilder("The input file seems to be corrupt"))),
    TARGET_INACCESSIBLE(-3, Reaction.with((Reaction.IExceptionBuilder)new Reaction.FileSystemInteractionExceptionBuilder("Could not access target file"))),
    INPUT_NOT_FOUND(-4, Reaction.with((Reaction.IExceptionBuilder)new Reaction.FileSystemInteractionExceptionBuilder("The input file does not exist or cannot be accessed"))),
    ILLEGAL_CALL(-5, Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConverterAccessExceptionBuilder("A converter script seems to be erroneous"))),
    CONVERTER_INACCESSIBLE(-6, Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConverterAccessExceptionBuilder("The converter seems to be shut down"))),
    UNKNOWN(null, Reaction.with((boolean)false));

    private final Integer exitValue;
    private final Reaction reaction;

    private ExternalConverterScriptResult(Integer exitValue, Reaction reaction) {
        this.exitValue = exitValue;
        this.reaction = reaction;
    }

    public static ExternalConverterScriptResult from(int exitValue) {
        for (ExternalConverterScriptResult shellResult : ExternalConverterScriptResult.values()) {
            if (!Objects.equal((Object)exitValue, (Object)shellResult.getExitValue())) continue;
            return shellResult;
        }
        return UNKNOWN;
    }

    public boolean resolve() {
        return this.reaction.apply();
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public String toString() {
        return Objects.toStringHelper(ExternalConverterScriptResult.class).add("exitValue", (Object)this.exitValue).add("reaction", (Object)this.reaction).toString();
    }
}

