/*
 * Decompiled with CFR 0.152.
 */
package com.devsoap.plugin;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class PayaraServerRunner {
    private static final Logger LOGGER = Logger.getLogger(PayaraServerRunner.class.getName());

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        Level logLevel = Level.parse(args[4]);
        String workdir = args[6];
        LOGGER.log(Level.CONFIG, "Configuring logger log levels to " + logLevel);
        Logger.getLogger("").getHandlers()[0].setLevel(logLevel);
        Logger.getLogger("javax.enterprise.system.tools.deployment").setLevel(logLevel);
        Logger.getLogger("javax.enterprise.system").setLevel(logLevel);
        LOGGER.log(Level.INFO, "Starting Payara web server...");
        try {
            BootstrapProperties bootstrap = new BootstrapProperties();
            GlassFishRuntime runtime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrap, (ClassLoader)PayaraServerRunner.class.getClass().getClassLoader());
            GlassFishProperties glassfishProperties = new GlassFishProperties();
            glassfishProperties.setPort("http-listener", port);
            LOGGER.log(Level.INFO, "Running on port " + port);
            GlassFish glassfish = runtime.newGlassFish(glassfishProperties);
            glassfish.start();
            Deployer deployer = glassfish.getDeployer();
            File work = new File(workdir);
            File explodedWar = new File(work, "war");
            deployer.deploy(explodedWar, new String[]{"--contextroot="});
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to start Payara server", ex);
            throw ex;
        }
    }
}

