/*
 * Decompiled with CFR 0.152.
 */
package com.devsoap.plugin.tasks;

import com.devsoap.plugin.Util;
import com.devsoap.plugin.tasks.BuildClassPathJar;
import com.devsoap.plugin.tasks.CompressCssTask;
import com.devsoap.plugin.tasks.UpdateAddonStylesTask;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildActionFailureException;

@CacheableTask
public class CompileThemeTask
extends DefaultTask
implements GroovyObject {
    private static final String NAME = "vaadinThemeCompile";
    private static final String STYLES_CSS = "styles.css";
    private static final String STYLES_SCSS_PATTERN = "**/styles.scss";
    private static final String CLASSPATH_SWITCH = "-cp";
    private static final String TEMPDIR_SWITCH = "-Djava.io.tmpdir";
    private static final String RUBY_MAIN_CLASS = "org.jruby.Main";
    private static final String COMPASS_COMPILER = "compass";
    private static final String LIBSASS_COMPILER = "libsass";
    private static final String VAADIN_COMPILER = "vaadin";
    private static final String STYLES_SCSS = "styles.scss";
    private final PropertyState<String> themesDirectory;
    private final PropertyState<String> compiler;
    private final PropertyState<Boolean> compress;
    private final PropertyState<Boolean> useClasspathJar;
    private final PropertyState<List<String>> jvmArgs;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CompileThemeTask() {
        MetaClass metaClass;
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), String.class);
        this.themesDirectory = (PropertyState)ScriptBytecodeAdapter.castToType((Object)object, PropertyState.class);
        Object object2 = callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), String.class);
        this.compiler = (PropertyState)ScriptBytecodeAdapter.castToType((Object)object2, PropertyState.class);
        Object object3 = callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), Boolean.class);
        this.compress = (PropertyState)ScriptBytecodeAdapter.castToType((Object)object3, PropertyState.class);
        Object object4 = callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), Boolean.class);
        this.useClasspathJar = (PropertyState)ScriptBytecodeAdapter.castToType((Object)object4, PropertyState.class);
        Object object5 = callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this), List.class);
        this.jvmArgs = (PropertyState)ScriptBytecodeAdapter.castToType((Object)object5, PropertyState.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[10].callCurrent((GroovyObject)this, (Object)"classes", callSiteArray[11].callGetProperty(BuildClassPathJar.class), callSiteArray[12].callGetProperty(UpdateAddonStylesTask.class));
        String string = "Compiles a Vaadin SASS theme into CSS";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, CompileThemeTask.class, (GroovyObject)this, (String)"description");
        callSiteArray[13].call(this.themesDirectory, null);
        callSiteArray[14].call(this.compiler, (Object)VAADIN_COMPILER);
        callSiteArray[15].call(this.compress, (Object)true);
        callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this), (Object)new _closure1((Object)this, (Object)this));
    }

    public String getThemesDirectory() {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[18].call(this.themesDirectory));
    }

    public void setThemesDirectory(String directory) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        callSiteArray[19].call(this.themesDirectory, (Object)directory);
    }

    @Input
    public String getCompiler() {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[20].call(this.compiler));
    }

    public void setCompiler(String compiler) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        callSiteArray[21].call(this.compiler, (Object)compiler);
    }

    @Input
    public Boolean getCompress() {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(this.compress), Boolean.class);
    }

    public void setCompress(Boolean compress) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        callSiteArray[23].call(this.compress, (Object)compress);
    }

    public Boolean getUseClasspathJar() {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(this.useClasspathJar), Boolean.class);
    }

    public void setUseClasspathJar(Boolean enabled) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        callSiteArray[25].call(this.useClasspathJar, (Object)enabled);
    }

    public void setUseClasspathJar(Provider<Boolean> enabled) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        callSiteArray[26].call(this.useClasspathJar, enabled);
    }

    public String[] getJvmArgs() {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        return (String[])ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGetProperty(this.jvmArgs)) ? callSiteArray[28].call(callSiteArray[29].call(this.jvmArgs), (Object)new String[DefaultTypeTransformation.intUnbox((Object)callSiteArray[30].call(callSiteArray[31].call(this.jvmArgs)))]) : null, String[].class);
    }

    public void setJvmArgs(String ... args) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        callSiteArray[32].call(this.jvmArgs, callSiteArray[33].call(Arrays.class, (Object)args));
    }

    @TaskAction
    public void exec() {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        callSiteArray[34].callStatic(CompileThemeTask.class, callSiteArray[35].callGroovyObjectGetProperty((Object)this));
    }

    public static Object compile(Project project, boolean isRecompile) {
        Reference project2 = new Reference((Object)project);
        Reference isRecompile2 = new Reference((Object)isRecompile);
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        File themesDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call(Util.class, (Object)((Project)project2.get())), File.class);
        callSiteArray[37].call(callSiteArray[38].callGetProperty((Object)((Project)project2.get())), callSiteArray[39].call((Object)"Compiling themes found in ", (Object)themesDir));
        FileTree themes = (FileTree)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call((Object)((Project)project2.get()), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"dir", themesDir, "include", STYLES_SCSS_PATTERN})), FileTree.class);
        callSiteArray[41].call(callSiteArray[42].callGetProperty((Object)((Project)project2.get())), (Object)new GStringImpl(new Object[]{callSiteArray[43].call(callSiteArray[44].callGetProperty((Object)themes))}, new String[]{"Found ", " themes."}));
        Reference compileThemeTask = new Reference((Object)((CompileThemeTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].call(callSiteArray[46].callGetProperty((Object)((Project)project2.get())), callSiteArray[47].callGetProperty(CompileThemeTask.class)), CompileThemeTask.class))));
        Reference gemsDir = new Reference(null);
        File cfr_ignored_0 = (File)gemsDir.get();
        if (ScriptBytecodeAdapter.isCase((Object)callSiteArray[48].call((Object)((CompileThemeTask)((Object)compileThemeTask.get()))), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{COMPASS_COMPILER}))) {
            Object object = callSiteArray[49].callStatic(CompileThemeTask.class, (Object)((Project)project2.get()));
            gemsDir.set((Object)((File)ScriptBytecodeAdapter.castToType((Object)object, File.class)));
        }
        Reference unpackedThemesDir = new Reference(null);
        File cfr_ignored_1 = (File)unpackedThemesDir.get();
        if (ScriptBytecodeAdapter.isCase((Object)callSiteArray[50].call((Object)((CompileThemeTask)((Object)compileThemeTask.get()))), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{COMPASS_COMPILER, LIBSASS_COMPILER}))) {
            Object object = callSiteArray[51].callStatic(CompileThemeTask.class, (Object)((Project)project2.get()));
            unpackedThemesDir.set((Object)((File)ScriptBytecodeAdapter.castToType((Object)object, File.class)));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].call((Object)((CompileThemeTask)((Object)compileThemeTask.get()))))) {
            Object object = callSiteArray[53].callStatic(CompileThemeTask.class, (Object)((Project)project2.get()));
            unpackedThemesDir.set((Object)((File)ScriptBytecodeAdapter.castToType((Object)object, File.class)));
        }
        public class _compile_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference isRecompile;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference compileThemeTask;
            private /* synthetic */ Reference unpackedThemesDir;
            private /* synthetic */ Reference gemsDir;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _compile_closure2(Object _outerInstance, Object _thisObject, Reference isRecompile, Reference project, Reference compileThemeTask, Reference unpackedThemesDir, Reference gemsDir) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.isRecompile = reference5 = isRecompile;
                this.project = reference4 = project;
                this.compileThemeTask = reference3 = compileThemeTask;
                this.unpackedThemesDir = reference2 = unpackedThemesDir;
                this.gemsDir = reference = gemsDir;
            }

            public Object doCall(File theme) {
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                File dir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(File.class, callSiteArray[1].callGetProperty((Object)theme)), File.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)this.isRecompile.get())) {
                    callSiteArray[2].call(callSiteArray[3].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{callSiteArray[4].callGetProperty((Object)theme)}, new String[]{"Recompiling ", "..."}));
                } else {
                    callSiteArray[5].call(callSiteArray[6].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{callSiteArray[7].callGetProperty((Object)theme)}, new String[]{"Compiling ", "..."}));
                }
                Object start = callSiteArray[8].call(System.class);
                Process process = null;
                Object object = callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(this.project.get()));
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[11].callGetProperty(CompileThemeTask.class))) {
                    File targetCss = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callConstructor(File.class, (Object)dir, callSiteArray[13].callGetProperty(CompileThemeTask.class)), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call(this.compileThemeTask.get()))) {
                        File sourceScss = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].call(Paths.class, callSiteArray[17].callGetProperty(this.unpackedThemesDir.get()), callSiteArray[18].callGetProperty((Object)dir), callSiteArray[19].callGetProperty((Object)theme))), File.class);
                        Object object2 = callSiteArray[20].callCurrent((GroovyObject)this, this.project.get(), (Object)sourceScss, (Object)targetCss);
                        process = (Process)ScriptBytecodeAdapter.castToType((Object)object2, Process.class);
                    } else {
                        Object object3 = callSiteArray[21].callCurrent((GroovyObject)this, this.project.get(), (Object)theme, (Object)targetCss);
                        process = (Process)ScriptBytecodeAdapter.castToType((Object)object3, Process.class);
                    }
                } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[22].callGetProperty(CompileThemeTask.class))) {
                    Object object4 = callSiteArray[23].callCurrent((GroovyObject)this, this.project.get(), this.gemsDir.get(), this.unpackedThemesDir.get(), (Object)dir);
                    process = (Process)ScriptBytecodeAdapter.castToType((Object)object4, Process.class);
                } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[24].callGetProperty(CompileThemeTask.class))) {
                    Object object5 = callSiteArray[25].callCurrent((GroovyObject)this, this.project.get(), (Object)dir, this.unpackedThemesDir.get());
                    process = (Process)ScriptBytecodeAdapter.castToType((Object)object5, Process.class);
                } else {
                    throw (Throwable)callSiteArray[26].callConstructor(BuildActionFailureException.class, (Object)new GStringImpl(new Object[]{callSiteArray[27].callGetProperty(callSiteArray[28].callGetProperty(this.project.get()))}, new String[]{"Selected theme compiler \"", "\" is not valid"}), null);
                }
                Reference failed = new Reference((Object)false);
                public class _closure7
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference failed;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure7(Object _outerInstance, Object _thisObject, Reference project, Reference failed) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.project = reference2 = project;
                        this.failed = reference = failed;
                    }

                    public Object doCall(String line) {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)line, (Object)"error"))) {
                            callSiteArray[1].call(callSiteArray[2].callGetProperty(this.project.get()), (Object)line);
                            boolean bl = true;
                            this.failed.set((Object)bl);
                            return false;
                        }
                        return true;
                    }

                    public Object call(String line) {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[3].callCurrent((GroovyObject)this, (Object)line);
                        }
                        return this.doCall(line);
                    }

                    public Project getProject() {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    public Boolean getFailed() {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.failed.get(), Boolean.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "contains";
                        stringArray[1] = "error";
                        stringArray[2] = "logger";
                        stringArray[3] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure7.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure7.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure7.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[29].call(Util.class, this.project.get(), (Object)process, (Object)"theme-compile.log", (Object)new _closure7((Object)this, this.getThisObject(), this.project, failed));
                int result = DefaultTypeTransformation.intUnbox((Object)callSiteArray[30].call((Object)process));
                long time = DefaultTypeTransformation.longUnbox((Object)callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(System.class), start), (Object)1000));
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (result != 0 || DefaultTypeTransformation.booleanUnbox((Object)((Boolean)failed.get()))) {
                        callSiteArray[34].call(callSiteArray[35].callConstructor(File.class, (Object)dir, callSiteArray[36].callGetProperty(CompileThemeTask.class)));
                        throw (Throwable)callSiteArray[37].callConstructor(BuildActionFailureException.class, (Object)"Theme compilation failed. See error log for details.", null);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)this.isRecompile.get())) {
                        return callSiteArray[38].call(callSiteArray[39].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{time}, new String[]{"Theme was recompiled in ", " seconds"}));
                    }
                    return callSiteArray[40].call(callSiteArray[41].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{time}, new String[]{"Theme was compiled in ", " seconds"}));
                }
                if (result != 0 || DefaultTypeTransformation.booleanUnbox((Object)((Boolean)failed.get()))) {
                    callSiteArray[42].call(callSiteArray[43].callConstructor(File.class, (Object)dir, callSiteArray[44].callGetProperty(CompileThemeTask.class)));
                    throw (Throwable)callSiteArray[45].callConstructor(BuildActionFailureException.class, (Object)"Theme compilation failed. See error log for details.", null);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)this.isRecompile.get())) {
                    return callSiteArray[46].call(callSiteArray[47].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{time}, new String[]{"Theme was recompiled in ", " seconds"}));
                }
                return callSiteArray[48].call(callSiteArray[49].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{time}, new String[]{"Theme was compiled in ", " seconds"}));
            }

            public Object call(File theme) {
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                return callSiteArray[50].callCurrent((GroovyObject)this, (Object)theme);
            }

            public boolean getIsRecompile() {
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.isRecompile.get());
            }

            public Project getProject() {
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public CompileThemeTask getCompileThemeTask() {
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                return (CompileThemeTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.compileThemeTask.get(), CompileThemeTask.class));
            }

            public File getUnpackedThemesDir() {
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedThemesDir.get(), File.class);
            }

            public File getGemsDir() {
                CallSite[] callSiteArray = _compile_closure2.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.gemsDir.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "parent";
                stringArray[2] = "lifecycle";
                stringArray[3] = "logger";
                stringArray[4] = "canonicalPath";
                stringArray[5] = "info";
                stringArray[6] = "logger";
                stringArray[7] = "canonicalPath";
                stringArray[8] = "currentTimeMillis";
                stringArray[9] = "compiler";
                stringArray[10] = CompileThemeTask.NAME;
                stringArray[11] = "VAADIN_COMPILER";
                stringArray[12] = "<$constructor$>";
                stringArray[13] = "STYLES_CSS";
                stringArray[14] = "getThemesDirectory";
                stringArray[15] = "toFile";
                stringArray[16] = "get";
                stringArray[17] = "canonicalPath";
                stringArray[18] = "name";
                stringArray[19] = "name";
                stringArray[20] = "executeVaadinSassCompiler";
                stringArray[21] = "executeVaadinSassCompiler";
                stringArray[22] = "COMPASS_COMPILER";
                stringArray[23] = "executeCompassSassCompiler";
                stringArray[24] = "LIBSASS_COMPILER";
                stringArray[25] = "executeLibSassCompiler";
                stringArray[26] = "<$constructor$>";
                stringArray[27] = "compiler";
                stringArray[28] = CompileThemeTask.NAME;
                stringArray[29] = "logProcess";
                stringArray[30] = "waitFor";
                stringArray[31] = "div";
                stringArray[32] = "minus";
                stringArray[33] = "currentTimeMillis";
                stringArray[34] = "delete";
                stringArray[35] = "<$constructor$>";
                stringArray[36] = "STYLES_CSS";
                stringArray[37] = "<$constructor$>";
                stringArray[38] = "lifecycle";
                stringArray[39] = "logger";
                stringArray[40] = "info";
                stringArray[41] = "logger";
                stringArray[42] = "delete";
                stringArray[43] = "<$constructor$>";
                stringArray[44] = "STYLES_CSS";
                stringArray[45] = "<$constructor$>";
                stringArray[46] = "lifecycle";
                stringArray[47] = "logger";
                stringArray[48] = "info";
                stringArray[49] = "logger";
                stringArray[50] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[51];
                _compile_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_compile_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _compile_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[54].call((Object)themes, (Object)new _compile_closure2(CompileThemeTask.class, CompileThemeTask.class, isRecompile2, project2, compileThemeTask, unpackedThemesDir, gemsDir));
    }

    private static Process executeVaadinSassCompiler(Project project, File themeDir, File targetCSSFile) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        CompileThemeTask compileThemeTask = (CompileThemeTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(callSiteArray[56].callGetProperty((Object)project), callSiteArray[57].callGetProperty(CompileThemeTask.class)), CompileThemeTask.class));
        Object compileProcess = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[58].call(Util.class, (Object)project)});
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].call((Object)compileThemeTask))) {
            compileProcess = callSiteArray[60].call(compileProcess, (Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[61].call((Object)compileThemeTask), List.class)));
        }
        compileProcess = callSiteArray[62].call(compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{TEMPDIR_SWITCH, callSiteArray[63].callGetProperty(callSiteArray[64].callGroovyObjectGetProperty((Object)compileThemeTask))}, new String[]{"", "=", ""})}));
        compileProcess = callSiteArray[65].call(compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{CLASSPATH_SWITCH, callSiteArray[66].callGetProperty(callSiteArray[67].call(Util.class, (Object)project))}));
        compileProcess = callSiteArray[68].call(compileProcess, (Object)"com.vaadin.sass.SassCompiler");
        compileProcess = callSiteArray[69].call(compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[70].callGetProperty((Object)themeDir), callSiteArray[71].callGetProperty((Object)targetCSSFile)}));
        return (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].call(compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), callSiteArray[73].callGetProperty((Object)project)), Process.class);
    }

    private static File installCompassGem(Project project) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        File gemsDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].call(callSiteArray[75].call(Paths.class, callSiteArray[76].callGetProperty(callSiteArray[77].callGetProperty((Object)project)), (Object)"jruby", (Object)"gems")), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].call((Object)gemsDir))) {
            Object object;
            callSiteArray[79].call((Object)gemsDir);
            callSiteArray[80].call(callSiteArray[81].callGetProperty((Object)project), (Object)"Installing compass ruby gem...");
            Object gemProcess = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[82].call(Util.class, (Object)project)});
            gemProcess = callSiteArray[83].call(gemProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{CLASSPATH_SWITCH, callSiteArray[84].callGetProperty(callSiteArray[85].call(Util.class, (Object)project))}));
            gemProcess = callSiteArray[86].call(gemProcess, (Object)RUBY_MAIN_CLASS);
            gemProcess = callSiteArray[87].call(gemProcess, callSiteArray[88].call((Object)new GStringImpl(new Object[]{gemsDir}, new String[]{"-S gem install -i ", " --no-rdoc --no-ri compass"})));
            callSiteArray[89].call(callSiteArray[90].callGetProperty((Object)project), callSiteArray[91].call(gemProcess));
            gemProcess = object = callSiteArray[92].call(gemProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{callSiteArray[93].callGetProperty((Object)gemsDir)}, new String[]{"GEM_PATH=", ""}), new GStringImpl(new Object[]{callSiteArray[94].callGetProperty((Object)gemsDir)}, new String[]{"PATH=", "/bin"})}), callSiteArray[95].callGetProperty((Object)project));
            public class _installCompassGem_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _installCompassGem_closure3(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _installCompassGem_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _installCompassGem_closure3.$getCallSiteArray();
                    return true;
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _installCompassGem_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _installCompassGem_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_installCompassGem_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _installCompassGem_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[96].call(Util.class, (Object)project, gemProcess, (Object)"compass-gem-install.log", (Object)new _installCompassGem_closure3(CompileThemeTask.class, CompileThemeTask.class));
            Object result = callSiteArray[97].call(gemProcess);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)result, (Object)0)) {
                throw (Throwable)callSiteArray[98].callConstructor(BuildActionFailureException.class, callSiteArray[99].call((Object)"Installing Compass ruby gem failed. ", (Object)"See compass-gem-install.log for further information."), null);
            }
        }
        return gemsDir;
    }

    private static File unpackThemes(Project project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        Reference unpackedVaadinDir = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].call((Object)((Project)project2.get()), (Object)new GStringImpl(new Object[]{callSiteArray[101].callGetProperty((Object)((Project)project2.get()))}, new String[]{"", "/VAADIN"})), File.class)));
        Reference unpackedThemesDir = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].call((Object)((Project)project2.get()), (Object)new GStringImpl(new Object[]{(File)unpackedVaadinDir.get()}, new String[]{"", "/themes"})), File.class)));
        File unpackedAddonsThemesDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].call((Object)((Project)project2.get()), (Object)new GStringImpl(new Object[]{(File)unpackedVaadinDir.get()}, new String[]{"", "/addons"})), File.class);
        callSiteArray[104].call((Object)((File)unpackedThemesDir.get()));
        callSiteArray[105].call((Object)unpackedAddonsThemesDir);
        callSiteArray[106].call(callSiteArray[107].callGetProperty((Object)((Project)project2.get())), (Object)new GStringImpl(new Object[]{(File)unpackedThemesDir.get()}, new String[]{"Unpacking themes to ", ""}));
        Reference themesAttribute = new Reference(callSiteArray[108].callConstructor(Attributes.Name.class, (Object)"Vaadin-Stylesheets"));
        Reference bundleName = new Reference(callSiteArray[109].callConstructor(Attributes.Name.class, (Object)"Bundle-Name"));
        public class _unpackThemes_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference unpackedThemesDir;
            private /* synthetic */ Reference themesAttribute;
            private /* synthetic */ Reference bundleName;
            private /* synthetic */ Reference unpackedVaadinDir;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _unpackThemes_closure4(Object _outerInstance, Object _thisObject, Reference project, Reference unpackedThemesDir, Reference themesAttribute, Reference bundleName, Reference unpackedVaadinDir) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.project = reference5 = project;
                this.unpackedThemesDir = reference4 = unpackedThemesDir;
                this.themesAttribute = reference3 = themesAttribute;
                this.bundleName = reference2 = bundleName;
                this.unpackedVaadinDir = reference = unpackedVaadinDir;
            }

            public Object doCall(Configuration conf) {
                Reference conf2 = new Reference((Object)conf);
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                public class _closure8
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference unpackedThemesDir;
                    private /* synthetic */ Reference conf;
                    private /* synthetic */ Reference themesAttribute;
                    private /* synthetic */ Reference bundleName;
                    private /* synthetic */ Reference unpackedVaadinDir;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure8(Object _outerInstance, Object _thisObject, Reference project, Reference unpackedThemesDir, Reference conf, Reference themesAttribute, Reference bundleName, Reference unpackedVaadinDir) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.project = reference6 = project;
                        this.unpackedThemesDir = reference5 = unpackedThemesDir;
                        this.conf = reference4 = conf;
                        this.themesAttribute = reference3 = themesAttribute;
                        this.bundleName = reference2 = bundleName;
                        this.unpackedVaadinDir = reference = unpackedVaadinDir;
                    }

                    public Object doCall(Dependency dependency) {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        if (ScriptBytecodeAdapter.isCase((Object)dependency, ProjectDependency.class)) {
                            Object dependentProject = callSiteArray[0].callGetProperty((Object)dependency);
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(dependentProject, callSiteArray[2].callGroovyObjectGetProperty((Object)this)))) {
                                public class _closure9
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference project;
                                    private /* synthetic */ Reference unpackedThemesDir;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _closure9(Object _outerInstance, Object _thisObject, Reference project, Reference unpackedThemesDir) {
                                        Reference reference;
                                        Reference reference2;
                                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                        this.project = reference2 = project;
                                        this.unpackedThemesDir = reference = unpackedThemesDir;
                                    }

                                    public Object doCall(Object it) {
                                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                        callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(Util.class, this.project.get()));
                                        return callSiteArray[2].callCurrent((GroovyObject)this, this.unpackedThemesDir.get());
                                    }

                                    public Project getProject() {
                                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                                    }

                                    public File getUnpackedThemesDir() {
                                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                        return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedThemesDir.get(), File.class);
                                    }

                                    public Object doCall() {
                                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "from";
                                        stringArray[1] = "getThemesDirectory";
                                        stringArray[2] = "into";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[3];
                                        _closure9.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_closure9.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _closure9.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                return callSiteArray[3].call(dependentProject, (Object)new _closure9((Object)this, this.getThisObject(), this.project, this.unpackedThemesDir));
                            }
                            return null;
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(Util.class, this.project.get(), this.conf.get()))) {
                            public class _closure10
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference themesAttribute;
                                private /* synthetic */ Reference bundleName;
                                private /* synthetic */ Reference project;
                                private /* synthetic */ Reference unpackedVaadinDir;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _closure10(Object _outerInstance, Object _thisObject, Reference themesAttribute, Reference bundleName, Reference project, Reference unpackedVaadinDir) {
                                    Reference reference;
                                    Reference reference2;
                                    Reference reference3;
                                    Reference reference4;
                                    CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                    this.themesAttribute = reference4 = themesAttribute;
                                    this.bundleName = reference3 = bundleName;
                                    this.project = reference2 = project;
                                    this.unpackedVaadinDir = reference = unpackedVaadinDir;
                                }

                                public Object doCall(File file) {
                                    Reference file2 = new Reference((Object)file);
                                    CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                    public class _closure11
                                    extends Closure
                                    implements GeneratedClosure {
                                        private /* synthetic */ Reference themesAttribute;
                                        private /* synthetic */ Reference bundleName;
                                        private /* synthetic */ Reference project;
                                        private /* synthetic */ Reference file;
                                        private /* synthetic */ Reference unpackedVaadinDir;
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;
                                        private static /* synthetic */ SoftReference $callSiteArray;

                                        public _closure11(Object _outerInstance, Object _thisObject, Reference themesAttribute, Reference bundleName, Reference project, Reference file, Reference unpackedVaadinDir) {
                                            Reference reference;
                                            Reference reference2;
                                            Reference reference3;
                                            Reference reference4;
                                            Reference reference5;
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            super(_outerInstance, _thisObject);
                                            this.themesAttribute = reference5 = themesAttribute;
                                            this.bundleName = reference4 = bundleName;
                                            this.project = reference3 = project;
                                            this.file = reference2 = file;
                                            this.unpackedVaadinDir = reference = unpackedVaadinDir;
                                        }

                                        public Object doCall(InputStream stream) {
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            Reference jarStream = new Reference(callSiteArray[0].callConstructor(JarInputStream.class, (Object)stream));
                                            public class _closure12
                                            extends Closure
                                            implements GeneratedClosure {
                                                private /* synthetic */ Reference jarStream;
                                                private /* synthetic */ Reference themesAttribute;
                                                private /* synthetic */ Reference bundleName;
                                                private /* synthetic */ Reference project;
                                                private /* synthetic */ Reference file;
                                                private /* synthetic */ Reference unpackedVaadinDir;
                                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                                public static transient /* synthetic */ boolean __$stMC;
                                                private static /* synthetic */ SoftReference $callSiteArray;

                                                public _closure12(Object _outerInstance, Object _thisObject, Reference jarStream, Reference themesAttribute, Reference bundleName, Reference project, Reference file, Reference unpackedVaadinDir) {
                                                    Reference reference;
                                                    Reference reference2;
                                                    Reference reference3;
                                                    Reference reference4;
                                                    Reference reference5;
                                                    Reference reference6;
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    super(_outerInstance, _thisObject);
                                                    this.jarStream = reference6 = jarStream;
                                                    this.themesAttribute = reference5 = themesAttribute;
                                                    this.bundleName = reference4 = bundleName;
                                                    this.project = reference3 = project;
                                                    this.file = reference2 = file;
                                                    this.unpackedVaadinDir = reference = unpackedVaadinDir;
                                                }

                                                public Object doCall(Object it) {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    Object mf = callSiteArray[0].callGetProperty(this.jarStream.get());
                                                    Object attributes = callSiteArray[1].callGetPropertySafe(mf);
                                                    String value = ShortTypeHandling.castToString((Object)callSiteArray[2].callSafe(attributes, this.themesAttribute.get()));
                                                    Boolean themesValue = ScriptBytecodeAdapter.isCase((Object)callSiteArray[3].callSafe(attributes, this.bundleName.get()), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"vaadin-themes", "Vaadin Themes"}));
                                                    if (DefaultTypeTransformation.booleanUnbox((Object)value) || DefaultTypeTransformation.booleanUnbox((Object)themesValue)) {
                                                        callSiteArray[4].call(callSiteArray[5].callGetProperty(this.project.get()), (Object)new GStringImpl(new Object[]{this.file.get()}, new String[]{"Unpacking ", ""}));
                                                        public class _closure13
                                                        extends Closure
                                                        implements GeneratedClosure {
                                                            private /* synthetic */ Reference project;
                                                            private /* synthetic */ Reference file;
                                                            private /* synthetic */ Reference unpackedVaadinDir;
                                                            private static /* synthetic */ ClassInfo $staticClassInfo;
                                                            public static transient /* synthetic */ boolean __$stMC;
                                                            private static /* synthetic */ SoftReference $callSiteArray;

                                                            public _closure13(Object _outerInstance, Object _thisObject, Reference project, Reference file, Reference unpackedVaadinDir) {
                                                                Reference reference;
                                                                Reference reference2;
                                                                Reference reference3;
                                                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                                                super(_outerInstance, _thisObject);
                                                                this.project = reference3 = project;
                                                                this.file = reference2 = file;
                                                                this.unpackedVaadinDir = reference = unpackedVaadinDir;
                                                            }

                                                            public Object doCall(Object it) {
                                                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                                                boolean bl = false;
                                                                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, _closure13.class, (GroovyObject)this, (String)"includeEmptyDirs");
                                                                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(this.project.get(), this.file.get()));
                                                                callSiteArray[2].callCurrent((GroovyObject)this, this.unpackedVaadinDir.get());
                                                                callSiteArray[3].callCurrent((GroovyObject)this, (Object)"VAADIN/themes/**/*", (Object)"VAADIN/addons/**/*");
                                                                public class _closure14
                                                                extends Closure
                                                                implements GeneratedClosure {
                                                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                                                    public static transient /* synthetic */ boolean __$stMC;
                                                                    private static /* synthetic */ SoftReference $callSiteArray;

                                                                    public _closure14(Object _outerInstance, Object _thisObject) {
                                                                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                                                                        super(_outerInstance, _thisObject);
                                                                    }

                                                                    public Object doCall(Object details) {
                                                                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                                                                        Object object = callSiteArray[0].call(callSiteArray[1].callGetProperty(details), (Object)"VAADIN");
                                                                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)details, (String)"path");
                                                                        return object;
                                                                    }

                                                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                                        if (((Object)((Object)this)).getClass() != _closure14.class) {
                                                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                                        }
                                                                        ClassInfo classInfo = $staticClassInfo;
                                                                        if (classInfo == null) {
                                                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                                        }
                                                                        return classInfo.getMetaClass();
                                                                    }

                                                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                                                        stringArray[0] = "minus";
                                                                        stringArray[1] = "path";
                                                                    }

                                                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                                                        String[] stringArray = new String[2];
                                                                        _closure14.$createCallSiteArray_1(stringArray);
                                                                        return new CallSiteArray(_closure14.class, stringArray);
                                                                    }

                                                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                                                        CallSiteArray callSiteArray;
                                                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                                                            callSiteArray = _closure14.$createCallSiteArray();
                                                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                                                        }
                                                                        return callSiteArray.array;
                                                                    }
                                                                }
                                                                return callSiteArray[4].callCurrent((GroovyObject)this, (Object)new _closure14((Object)this, this.getThisObject()));
                                                            }

                                                            public Project getProject() {
                                                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                                                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                                                            }

                                                            public File getFile() {
                                                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                                                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                                                            }

                                                            public File getUnpackedVaadinDir() {
                                                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                                                return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedVaadinDir.get(), File.class);
                                                            }

                                                            public Object doCall() {
                                                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                                                return this.doCall(null);
                                                            }

                                                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                                if (((Object)((Object)this)).getClass() != _closure13.class) {
                                                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                                }
                                                                ClassInfo classInfo = $staticClassInfo;
                                                                if (classInfo == null) {
                                                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                                }
                                                                return classInfo.getMetaClass();
                                                            }

                                                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                                                stringArray[0] = "from";
                                                                stringArray[1] = "zipTree";
                                                                stringArray[2] = "into";
                                                                stringArray[3] = "include";
                                                                stringArray[4] = "eachFile";
                                                            }

                                                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                                                String[] stringArray = new String[5];
                                                                _closure13.$createCallSiteArray_1(stringArray);
                                                                return new CallSiteArray(_closure13.class, stringArray);
                                                            }

                                                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                                                CallSiteArray callSiteArray;
                                                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                                                    callSiteArray = _closure13.$createCallSiteArray();
                                                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                                                }
                                                                return callSiteArray.array;
                                                            }
                                                        }
                                                        return callSiteArray[6].call(this.project.get(), (Object)new _closure13((Object)this, this.getThisObject(), this.project, this.file, this.unpackedVaadinDir));
                                                    }
                                                    return null;
                                                }

                                                public Object getJarStream() {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    return this.jarStream.get();
                                                }

                                                public Object getThemesAttribute() {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    return this.themesAttribute.get();
                                                }

                                                public Object getBundleName() {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    return this.bundleName.get();
                                                }

                                                public Project getProject() {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                                                }

                                                public File getFile() {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                                                }

                                                public File getUnpackedVaadinDir() {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedVaadinDir.get(), File.class);
                                                }

                                                public Object doCall() {
                                                    CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                                    return this.doCall(null);
                                                }

                                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                    if (((Object)((Object)this)).getClass() != _closure12.class) {
                                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                    }
                                                    ClassInfo classInfo = $staticClassInfo;
                                                    if (classInfo == null) {
                                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                    }
                                                    return classInfo.getMetaClass();
                                                }

                                                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                                    stringArray[0] = "manifest";
                                                    stringArray[1] = "mainAttributes";
                                                    stringArray[2] = "getValue";
                                                    stringArray[3] = "getValue";
                                                    stringArray[4] = "info";
                                                    stringArray[5] = "logger";
                                                    stringArray[6] = "copy";
                                                }

                                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                                    String[] stringArray = new String[7];
                                                    _closure12.$createCallSiteArray_1(stringArray);
                                                    return new CallSiteArray(_closure12.class, stringArray);
                                                }

                                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                                    CallSiteArray callSiteArray;
                                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                                        callSiteArray = _closure12.$createCallSiteArray();
                                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                                    }
                                                    return callSiteArray.array;
                                                }
                                            }
                                            return callSiteArray[1].call(jarStream.get(), (Object)new _closure12((Object)this, this.getThisObject(), jarStream, this.themesAttribute, this.bundleName, this.project, this.file, this.unpackedVaadinDir));
                                        }

                                        public Object call(InputStream stream) {
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            return callSiteArray[2].callCurrent((GroovyObject)this, (Object)stream);
                                        }

                                        public Object getThemesAttribute() {
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            return this.themesAttribute.get();
                                        }

                                        public Object getBundleName() {
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            return this.bundleName.get();
                                        }

                                        public Project getProject() {
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                                        }

                                        public File getFile() {
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                                        }

                                        public File getUnpackedVaadinDir() {
                                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                            return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedVaadinDir.get(), File.class);
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _closure11.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                            stringArray[0] = "<$constructor$>";
                                            stringArray[1] = "withStream";
                                            stringArray[2] = "doCall";
                                        }

                                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                            String[] stringArray = new String[3];
                                            _closure11.$createCallSiteArray_1(stringArray);
                                            return new CallSiteArray(_closure11.class, stringArray);
                                        }

                                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                            CallSiteArray callSiteArray;
                                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                                callSiteArray = _closure11.$createCallSiteArray();
                                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                            }
                                            return callSiteArray.array;
                                        }
                                    }
                                    return callSiteArray[0].call((Object)((File)file2.get()), (Object)new _closure11((Object)this, this.getThisObject(), this.themesAttribute, this.bundleName, this.project, file2, this.unpackedVaadinDir));
                                }

                                public Object call(File file) {
                                    Reference file2 = new Reference((Object)file);
                                    CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)((File)file2.get()));
                                }

                                public Object getThemesAttribute() {
                                    CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                    return this.themesAttribute.get();
                                }

                                public Object getBundleName() {
                                    CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                    return this.bundleName.get();
                                }

                                public Project getProject() {
                                    CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                                }

                                public File getUnpackedVaadinDir() {
                                    CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                    return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedVaadinDir.get(), File.class);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure10.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                    stringArray[0] = "withInputStream";
                                    stringArray[1] = "doCall";
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[2];
                                    _closure10.$createCallSiteArray_1(stringArray);
                                    return new CallSiteArray(_closure10.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _closure10.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            return callSiteArray[5].call(callSiteArray[6].call(this.conf.get(), (Object)dependency), (Object)new _closure10((Object)this, this.getThisObject(), this.themesAttribute, this.bundleName, this.project, this.unpackedVaadinDir));
                        }
                        return null;
                    }

                    public Object call(Dependency dependency) {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return callSiteArray[7].callCurrent((GroovyObject)this, (Object)dependency);
                    }

                    public Project getProject() {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    public File getUnpackedThemesDir() {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedThemesDir.get(), File.class);
                    }

                    public Configuration getConf() {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.conf.get(), Configuration.class);
                    }

                    public Object getThemesAttribute() {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return this.themesAttribute.get();
                    }

                    public Object getBundleName() {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return this.bundleName.get();
                    }

                    public File getUnpackedVaadinDir() {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedVaadinDir.get(), File.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "dependencyProject";
                        stringArray[1] = "hasProperty";
                        stringArray[2] = "VAADIN_COMPILER";
                        stringArray[3] = "copy";
                        stringArray[4] = "isResolvable";
                        stringArray[5] = "each";
                        stringArray[6] = "files";
                        stringArray[7] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[8];
                        _closure8.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure8.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure8.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)((Configuration)conf2.get())), (Object)new _closure8((Object)this, this.getThisObject(), this.project, this.unpackedThemesDir, conf2, this.themesAttribute, this.bundleName, this.unpackedVaadinDir));
            }

            public Object call(Configuration conf) {
                Reference conf2 = new Reference((Object)conf);
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)((Configuration)conf2.get()));
            }

            public Project getProject() {
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public File getUnpackedThemesDir() {
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedThemesDir.get(), File.class);
            }

            public Object getThemesAttribute() {
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                return this.themesAttribute.get();
            }

            public Object getBundleName() {
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                return this.bundleName.get();
            }

            public File getUnpackedVaadinDir() {
                CallSite[] callSiteArray = _unpackThemes_closure4.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedVaadinDir.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _unpackThemes_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "allDependencies";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _unpackThemes_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_unpackThemes_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _unpackThemes_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[110].call(callSiteArray[111].callGetProperty(callSiteArray[112].callGetProperty((Object)((Project)project2.get()))), (Object)new _unpackThemes_closure4(CompileThemeTask.class, CompileThemeTask.class, project2, unpackedThemesDir, themesAttribute, bundleName, unpackedVaadinDir));
        callSiteArray[113].call(callSiteArray[114].callGetProperty((Object)((Project)project2.get())), (Object)new GStringImpl(new Object[]{(File)unpackedThemesDir.get()}, new String[]{"Copying project theme into ", ""}));
        public class _unpackThemes_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference unpackedThemesDir;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _unpackThemes_closure5(Object _outerInstance, Object _thisObject, Reference project, Reference unpackedThemesDir) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _unpackThemes_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.project = reference2 = project;
                this.unpackedThemesDir = reference = unpackedThemesDir;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _unpackThemes_closure5.$getCallSiteArray();
                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(Util.class, this.project.get()));
                return callSiteArray[2].callCurrent((GroovyObject)this, this.unpackedThemesDir.get());
            }

            public Project getProject() {
                CallSite[] callSiteArray = _unpackThemes_closure5.$getCallSiteArray();
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public File getUnpackedThemesDir() {
                CallSite[] callSiteArray = _unpackThemes_closure5.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.unpackedThemesDir.get(), File.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _unpackThemes_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _unpackThemes_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "from";
                stringArray[1] = "getThemesDirectory";
                stringArray[2] = "into";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _unpackThemes_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_unpackThemes_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _unpackThemes_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[115].call((Object)((Project)project2.get()), (Object)new _unpackThemes_closure5(CompileThemeTask.class, CompileThemeTask.class, project2, unpackedThemesDir));
        return (File)unpackedThemesDir.get();
    }

    private static Process executeCompassSassCompiler(Project project, File gemsDir, File unpackedThemesDir, File themeDir) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        File themePath = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].callConstructor(File.class, (Object)unpackedThemesDir, callSiteArray[117].callGetProperty((Object)themeDir)), File.class);
        String compassCompile = "-S compass compile ";
        compassCompile = ShortTypeHandling.castToString((Object)callSiteArray[118].call((Object)compassCompile, (Object)new GStringImpl(new Object[]{themePath}, new String[]{"--sass-dir ", " "})));
        compassCompile = ShortTypeHandling.castToString((Object)callSiteArray[119].call((Object)compassCompile, (Object)new GStringImpl(new Object[]{themeDir}, new String[]{"--css-dir ", " "})));
        compassCompile = ShortTypeHandling.castToString((Object)callSiteArray[120].call((Object)compassCompile, (Object)new GStringImpl(new Object[]{themePath}, new String[]{"--images-dir ", " "})));
        compassCompile = ShortTypeHandling.castToString((Object)callSiteArray[121].call((Object)compassCompile, (Object)new GStringImpl(new Object[]{themePath}, new String[]{"--javascripts-dir ", " "})));
        compassCompile = ShortTypeHandling.castToString((Object)callSiteArray[122].call((Object)compassCompile, (Object)"--relative-assets"));
        callSiteArray[123].call(callSiteArray[124].callGetProperty((Object)project), (Object)new GStringImpl(new Object[]{themePath}, new String[]{"Compiling ", " with compass compiler"}));
        CompileThemeTask compileThemeTask = (CompileThemeTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[125].call(callSiteArray[126].callGetProperty((Object)project), callSiteArray[127].callGetProperty(CompileThemeTask.class)), CompileThemeTask.class));
        List compileProcess = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[128].call(Util.class, (Object)project)});
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[129].call((Object)compileThemeTask))) {
            compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].call((Object)compileProcess, (Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[131].call((Object)compileThemeTask), List.class))), List.class);
        }
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[132].call((Object)compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{TEMPDIR_SWITCH, callSiteArray[133].callGetProperty(callSiteArray[134].callGroovyObjectGetProperty((Object)compileThemeTask))}, new String[]{"", "=", ""})})), List.class);
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].call((Object)compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{CLASSPATH_SWITCH, callSiteArray[136].callGetProperty(callSiteArray[137].call(Util.class, (Object)project))})), List.class);
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].call((Object)compileProcess, (Object)RUBY_MAIN_CLASS), List.class);
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].call((Object)compileProcess, callSiteArray[140].call((Object)compassCompile)), List.class);
        callSiteArray[141].call(callSiteArray[142].callGetProperty((Object)project), callSiteArray[143].call((Object)compileProcess));
        return (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[144].call((Object)compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{callSiteArray[145].callGetProperty((Object)gemsDir)}, new String[]{"GEM_PATH=", ""}), new GStringImpl(new Object[]{callSiteArray[146].callGetProperty((Object)gemsDir)}, new String[]{"PATH=", "/bin"})}), callSiteArray[147].callGetProperty((Object)project)), Process.class);
    }

    private static Process executeLibSassCompiler(Project project, File themeDir, File unpackedThemesDir) {
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        File stylesScss = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].callConstructor(File.class, (Object)themeDir, (Object)STYLES_SCSS), File.class);
        File stylesCss = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].callConstructor(File.class, (Object)themeDir, (Object)STYLES_CSS), File.class);
        callSiteArray[150].call(callSiteArray[151].callGetProperty((Object)project), (Object)new GStringImpl(new Object[]{themeDir}, new String[]{"Compiling ", " with libsass compiler"}));
        CompileThemeTask compileThemeTask = (CompileThemeTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].call(callSiteArray[153].callGetProperty((Object)project), callSiteArray[154].callGetProperty(CompileThemeTask.class)), CompileThemeTask.class));
        List compileProcess = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[155].call(Util.class, (Object)project)});
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[156].call((Object)compileThemeTask))) {
            compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[157].call((Object)compileProcess, (Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[158].call((Object)compileThemeTask), List.class))), List.class);
        }
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[159].call((Object)compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{TEMPDIR_SWITCH, callSiteArray[160].callGetProperty(callSiteArray[161].callGroovyObjectGetProperty((Object)compileThemeTask))}, new String[]{"", "=", ""})})), List.class);
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].call((Object)compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{CLASSPATH_SWITCH, callSiteArray[163].callGetProperty(callSiteArray[164].call(Util.class, (Object)project))})), List.class);
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].call((Object)compileProcess, (Object)"com.devsoap.plugin.LibSassCompiler"), List.class);
        compileProcess = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].call((Object)compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[167].callGetProperty((Object)stylesScss), callSiteArray[168].callGetProperty((Object)stylesCss), callSiteArray[169].callGetProperty((Object)unpackedThemesDir)})), List.class);
        callSiteArray[170].call(callSiteArray[171].callGetProperty((Object)project), callSiteArray[172].call((Object)compileProcess));
        return (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[173].call((Object)compileProcess, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), callSiteArray[174].callGetProperty((Object)project)), Process.class);
    }

    public static Object compile(Project project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = CompileThemeTask.$getCallSiteArray();
        return CompileThemeTask.compile((Project)project2.get(), false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != CompileThemeTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public static String getNAME() {
        return NAME;
    }

    public static String getSTYLES_CSS() {
        return STYLES_CSS;
    }

    public static String getSTYLES_SCSS_PATTERN() {
        return STYLES_SCSS_PATTERN;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "property";
        stringArray[1] = "project";
        stringArray[2] = "property";
        stringArray[3] = "project";
        stringArray[4] = "property";
        stringArray[5] = "project";
        stringArray[6] = "property";
        stringArray[7] = "project";
        stringArray[8] = "property";
        stringArray[9] = "project";
        stringArray[10] = "dependsOn";
        stringArray[11] = "NAME";
        stringArray[12] = "NAME";
        stringArray[13] = "set";
        stringArray[14] = "set";
        stringArray[15] = "set";
        stringArray[16] = "afterEvaluate";
        stringArray[17] = "project";
        stringArray[18] = "getOrNull";
        stringArray[19] = "set";
        stringArray[20] = "get";
        stringArray[21] = "set";
        stringArray[22] = "get";
        stringArray[23] = "set";
        stringArray[24] = "get";
        stringArray[25] = "set";
        stringArray[26] = "set";
        stringArray[27] = "present";
        stringArray[28] = "toArray";
        stringArray[29] = "get";
        stringArray[30] = "size";
        stringArray[31] = "get";
        stringArray[32] = "set";
        stringArray[33] = "asList";
        stringArray[34] = "compile";
        stringArray[35] = "project";
        stringArray[36] = "getThemesDirectory";
        stringArray[37] = "info";
        stringArray[38] = "logger";
        stringArray[39] = "plus";
        stringArray[40] = "fileTree";
        stringArray[41] = "info";
        stringArray[42] = "logger";
        stringArray[43] = "size";
        stringArray[44] = "files";
        stringArray[45] = "getByName";
        stringArray[46] = "tasks";
        stringArray[47] = "NAME";
        stringArray[48] = "getCompiler";
        stringArray[49] = "installCompassGem";
        stringArray[50] = "getCompiler";
        stringArray[51] = "unpackThemes";
        stringArray[52] = "getThemesDirectory";
        stringArray[53] = "unpackThemes";
        stringArray[54] = "each";
        stringArray[55] = "getByName";
        stringArray[56] = "tasks";
        stringArray[57] = "NAME";
        stringArray[58] = "getJavaBinary";
        stringArray[59] = "getJvmArgs";
        stringArray[60] = "plus";
        stringArray[61] = "getJvmArgs";
        stringArray[62] = "plus";
        stringArray[63] = "canonicalPath";
        stringArray[64] = "temporaryDir";
        stringArray[65] = "plus";
        stringArray[66] = "asPath";
        stringArray[67] = "getCompileClassPathOrJar";
        stringArray[68] = "plus";
        stringArray[69] = "plus";
        stringArray[70] = "canonicalPath";
        stringArray[71] = "canonicalPath";
        stringArray[72] = "execute";
        stringArray[73] = "buildDir";
        stringArray[74] = "toFile";
        stringArray[75] = "get";
        stringArray[76] = "canonicalPath";
        stringArray[77] = "buildDir";
        stringArray[78] = "exists";
        stringArray[79] = "mkdirs";
        stringArray[80] = "info";
        stringArray[81] = "logger";
        stringArray[82] = "getJavaBinary";
        stringArray[83] = "plus";
        stringArray[84] = "asPath";
        stringArray[85] = "getCompileClassPathOrJar";
        stringArray[86] = "plus";
        stringArray[87] = "plus";
        stringArray[88] = "tokenize";
        stringArray[89] = "debug";
        stringArray[90] = "logger";
        stringArray[91] = "toString";
        stringArray[92] = "execute";
        stringArray[93] = "canonicalPath";
        stringArray[94] = "canonicalPath";
        stringArray[95] = "buildDir";
        stringArray[96] = "logProcess";
        stringArray[97] = "waitFor";
        stringArray[98] = "<$constructor$>";
        stringArray[99] = "plus";
        stringArray[100] = "file";
        stringArray[101] = "buildDir";
        stringArray[102] = "file";
        stringArray[103] = "file";
        stringArray[104] = "mkdirs";
        stringArray[105] = "mkdirs";
        stringArray[106] = "info";
        stringArray[107] = "logger";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "each";
        stringArray[111] = "all";
        stringArray[112] = "configurations";
        stringArray[113] = "info";
        stringArray[114] = "logger";
        stringArray[115] = "copy";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "name";
        stringArray[118] = "plus";
        stringArray[119] = "plus";
        stringArray[120] = "plus";
        stringArray[121] = "plus";
        stringArray[122] = "plus";
        stringArray[123] = "info";
        stringArray[124] = "logger";
        stringArray[125] = "getByName";
        stringArray[126] = "tasks";
        stringArray[127] = "NAME";
        stringArray[128] = "getJavaBinary";
        stringArray[129] = "getJvmArgs";
        stringArray[130] = "plus";
        stringArray[131] = "getJvmArgs";
        stringArray[132] = "plus";
        stringArray[133] = "canonicalPath";
        stringArray[134] = "temporaryDir";
        stringArray[135] = "plus";
        stringArray[136] = "asPath";
        stringArray[137] = "getCompileClassPathOrJar";
        stringArray[138] = "plus";
        stringArray[139] = "plus";
        stringArray[140] = "tokenize";
        stringArray[141] = "debug";
        stringArray[142] = "logger";
        stringArray[143] = "toString";
        stringArray[144] = "execute";
        stringArray[145] = "canonicalPath";
        stringArray[146] = "canonicalPath";
        stringArray[147] = "buildDir";
        stringArray[148] = "<$constructor$>";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "info";
        stringArray[151] = "logger";
        stringArray[152] = "getByName";
        stringArray[153] = "tasks";
        stringArray[154] = "NAME";
        stringArray[155] = "getJavaBinary";
        stringArray[156] = "getJvmArgs";
        stringArray[157] = "plus";
        stringArray[158] = "getJvmArgs";
        stringArray[159] = "plus";
        stringArray[160] = "canonicalPath";
        stringArray[161] = "temporaryDir";
        stringArray[162] = "plus";
        stringArray[163] = "asPath";
        stringArray[164] = "getCompileClassPathOrJar";
        stringArray[165] = "plus";
        stringArray[166] = "plus";
        stringArray[167] = "canonicalPath";
        stringArray[168] = "canonicalPath";
        stringArray[169] = "canonicalPath";
        stringArray[170] = "debug";
        stringArray[171] = "logger";
        stringArray[172] = "toString";
        stringArray[173] = "execute";
        stringArray[174] = "buildDir";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[175];
        CompileThemeTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CompileThemeTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CompileThemeTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            File themesDirectory = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Util.class, callSiteArray[1].callGroovyObjectGetProperty((Object)this)), File.class);
            callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)themesDirectory);
            callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"dir", themesDirectory, "include", "**/*.scss"}))));
            public class _closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _closure6(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(File theme) {
                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(File.class, callSiteArray[1].callConstructor(File.class, callSiteArray[2].callGetProperty((Object)theme)), callSiteArray[3].callGroovyObjectGetProperty((Object)this));
                }

                public Object call(File theme) {
                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                    return callSiteArray[4].callCurrent((GroovyObject)this, (Object)theme);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "parent";
                    stringArray[3] = "STYLES_CSS";
                    stringArray[4] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this), callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"dir", themesDirectory, "include", callSiteArray[14].callGetProperty(CompileThemeTask.class)})), (Object)new _closure6((Object)this, this.getThisObject())));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callCurrent((GroovyObject)this))) {
                BuildClassPathJar pathJarTask = (BuildClassPathJar)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call(callSiteArray[17].callGetProperty(callSiteArray[18].callGroovyObjectGetProperty((Object)this)), callSiteArray[19].callGetProperty(BuildClassPathJar.class)), BuildClassPathJar.class));
                callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), callSiteArray[22].callGetProperty((Object)pathJarTask));
            }
            return callSiteArray[23].callCurrent((GroovyObject)this, callSiteArray[24].call(callSiteArray[25].callGetProperty(callSiteArray[26].callGroovyObjectGetProperty((Object)this)), callSiteArray[27].callGetProperty(CompressCssTask.class)));
        }

        public Object doCall() {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "getThemesDirectory";
            stringArray[1] = "project";
            stringArray[2] = "dir";
            stringArray[3] = "inputs";
            stringArray[4] = "files";
            stringArray[5] = "inputs";
            stringArray[6] = "collect";
            stringArray[7] = "fileTree";
            stringArray[8] = "project";
            stringArray[9] = "files";
            stringArray[10] = "outputs";
            stringArray[11] = "collect";
            stringArray[12] = "fileTree";
            stringArray[13] = "project";
            stringArray[14] = "STYLES_SCSS_PATTERN";
            stringArray[15] = "getUseClasspathJar";
            stringArray[16] = "getByName";
            stringArray[17] = "tasks";
            stringArray[18] = "project";
            stringArray[19] = "NAME";
            stringArray[20] = "file";
            stringArray[21] = "inputs";
            stringArray[22] = "archivePath";
            stringArray[23] = "finalizedBy";
            stringArray[24] = "getAt";
            stringArray[25] = "tasks";
            stringArray[26] = "project";
            stringArray[27] = "NAME";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[28];
            _closure1.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

