/*
 * Decompiled with CFR 0.152.
 */
package com.develouz.ads;

import android.view.View;
import android.view.ViewGroup;
import com.develouz.ads.AdBuilder;
import com.develouz.ads.AdCallback;
import com.develouz.ads.AdDesign;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;

public final class Facebook
extends AdDesign {
    private AdView banner;
    private InterstitialAd interstitial;
    private RewardedVideoAd rewarded;

    protected Facebook(AdBuilder ad) {
        super(ad);
    }

    protected void loadBanner(final AdCallback callback) {
        if (Facebook.empty((String)this.getAd().getBannerId())) {
            return;
        }
        if (this.banner != null) {
            this.banner.destroy();
        }
        this.banner = new AdView(this.getContext(), this.getAd().getBannerId(), AdSize.BANNER_HEIGHT_50);
        this.banner.setAdListener(new AdListener(){

            public void onError(Ad ad, AdError adError) {
                if (callback != null) {
                    callback.onError("onError: " + adError.getErrorCode() + " - " + adError.getErrorMessage());
                }
            }

            public void onAdLoaded(Ad ad) {
                if (callback != null) {
                    callback.onLoaded();
                }
            }

            public void onAdClicked(Ad ad) {
                if (callback != null) {
                    callback.onClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
            }
        });
        this.banner.loadAd();
    }

    protected void loadInterstitial(final AdCallback callback) {
        if (Facebook.empty((String)this.getAd().getInterstitialId())) {
            return;
        }
        if (this.interstitial != null) {
            this.interstitial.destroy();
        }
        this.interstitial = new InterstitialAd(this.getContext(), this.getAd().getInterstitialId());
        this.interstitial.setAdListener(new InterstitialAdListener(){

            public void onInterstitialDisplayed(Ad ad) {
            }

            public void onInterstitialDismissed(Ad ad) {
                if (callback != null) {
                    callback.onClosed();
                }
                Facebook.this.loadInterstitial(callback);
            }

            public void onError(Ad ad, AdError adError) {
                if (callback != null) {
                    callback.onError("onError: " + adError.getErrorCode() + " - " + adError.getErrorMessage());
                }
            }

            public void onAdLoaded(Ad ad) {
                if (callback != null) {
                    callback.onLoaded();
                }
            }

            public void onAdClicked(Ad ad) {
                if (callback != null) {
                    callback.onClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
            }
        });
        this.interstitial.loadAd();
    }

    protected void loadRewarded(final AdCallback callback) {
        if (Facebook.empty((String)this.getAd().getRewardedId())) {
            return;
        }
        if (this.rewarded != null) {
            this.rewarded.destroy();
        }
        this.rewarded = new RewardedVideoAd(this.getContext(), this.getAd().getRewardedId());
        this.rewarded.setAdListener(new RewardedVideoAdListener(){

            public void onRewardedVideoCompleted() {
                if (callback != null) {
                    callback.onCompleted();
                }
            }

            public void onError(Ad ad, AdError adError) {
                if (callback != null) {
                    callback.onError("onError: " + adError.getErrorCode() + " - " + adError.getErrorMessage());
                }
            }

            public void onLoggingImpression(Ad ad) {
            }

            public void onAdLoaded(Ad ad) {
                if (callback != null) {
                    callback.onLoaded();
                }
            }

            public void onRewardedVideoClosed() {
                if (callback != null) {
                    callback.onClosed();
                }
            }

            public void onAdClicked(Ad ad) {
                if (callback != null) {
                    callback.onClicked();
                }
            }
        });
        this.rewarded.loadAd();
    }

    protected boolean isBanner() {
        return this.banner != null;
    }

    protected boolean isInterstitial() {
        return this.interstitial != null && this.interstitial.isAdLoaded();
    }

    protected boolean isRewarded() {
        return this.rewarded != null && this.rewarded.isAdLoaded();
    }

    protected void showBanner(ViewGroup container) {
        if (this.isBanner()) {
            container.addView((View)this.banner);
        }
    }

    protected void showInterstitial() {
        if (this.isInterstitial()) {
            this.interstitial.show();
        }
    }

    protected void showRewarded() {
        if (this.isRewarded()) {
            this.rewarded.show();
        }
    }

    protected void destroy() {
        super.destroy();
        if (this.banner != null) {
            this.banner.destroy();
            this.banner = null;
        }
        if (this.interstitial != null) {
            this.interstitial.destroy();
            this.interstitial = null;
        }
        if (this.rewarded != null) {
            this.rewarded.destroy();
            this.rewarded = null;
        }
    }
}

