/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model;

import com.cronutils.mapper.CronMapper;
import com.cronutils.model.definition.CronConstraint;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.visitor.ValidationFieldExpressionVisitor;
import com.cronutils.utils.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.ejb.ScheduleExpression;

public class Cron
implements Serializable {
    private static final long serialVersionUID = 7487370826825439098L;
    private final CronDefinition cronDefinition;
    private final Map<CronFieldName, CronField> fields;
    private String asString;

    public Cron(CronDefinition cronDefinition, List<CronField> fields) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition, "CronDefinition must not be null");
        Preconditions.checkNotNull(fields, "CronFields cannot be null");
        this.fields = new EnumMap<CronFieldName, CronField>(CronFieldName.class);
        for (CronField field : fields) {
            this.fields.put(field.getField(), field);
        }
    }

    public CronField retrieve(CronFieldName name) {
        return this.fields.get((Object)Preconditions.checkNotNull(name, "CronFieldName must not be null"));
    }

    public Map<CronFieldName, CronField> retrieveFieldsAsMap() {
        return Collections.unmodifiableMap(this.fields);
    }

    public String asString() {
        if (this.asString == null) {
            ArrayList<CronField> temporaryFields = new ArrayList<CronField>(this.fields.values());
            temporaryFields.sort(CronField.createFieldComparator());
            StringBuilder builder = new StringBuilder();
            for (CronField field : temporaryFields) {
                builder.append(String.format("%s ", field.getExpression().asString()));
            }
            this.asString = builder.toString().trim();
        }
        return this.asString;
    }

    public CronDefinition getCronDefinition() {
        return this.cronDefinition;
    }

    public Cron validate() {
        for (Map.Entry<CronFieldName, CronField> field : this.retrieveFieldsAsMap().entrySet()) {
            CronFieldName fieldName = field.getKey();
            field.getValue().getExpression().accept(new ValidationFieldExpressionVisitor(this.getCronDefinition().getFieldDefinition(fieldName).getConstraints(), this.cronDefinition.isStrictRanges()));
        }
        for (CronConstraint constraint : this.getCronDefinition().getCronConstraints()) {
            if (constraint.validate(this)) continue;
            throw new IllegalArgumentException(String.format("Invalid cron expression: %s. %s", this.asString(), constraint.getDescription()));
        }
        return this;
    }

    public boolean equivalent(CronMapper cronMapper, Cron cron) {
        return this.asString().equals(cronMapper.map(cron).asString());
    }

    public boolean equivalent(Cron cron) {
        return this.asString().equals(cron.asString());
    }

    public ScheduleExpression asScheduleExpression() {
        if (this.asString().contains("?")) {
            throw new IllegalArgumentException("? not supported by ScheduleExpression");
        }
        ScheduleExpression expression = new ScheduleExpression();
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.YEAR)) {
            expression.year(this.retrieve(CronFieldName.YEAR).getExpression().asString());
        }
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.DAY_OF_YEAR)) {
            throw new IllegalArgumentException("DoY not supported by ScheduleExpression");
        }
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.DAY_OF_WEEK)) {
            expression.dayOfWeek(this.retrieve(CronFieldName.DAY_OF_WEEK).getExpression().asString());
        }
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.MONTH)) {
            expression.month(this.retrieve(CronFieldName.MONTH).getExpression().asString());
        }
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.DAY_OF_MONTH)) {
            expression.dayOfMonth(this.retrieve(CronFieldName.DAY_OF_MONTH).getExpression().asString());
        }
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.HOUR)) {
            expression.hour(this.retrieve(CronFieldName.HOUR).getExpression().asString());
        }
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.MINUTE)) {
            expression.minute(this.retrieve(CronFieldName.MINUTE).getExpression().asString());
        }
        if (this.cronDefinition.containsFieldDefinition(CronFieldName.SECOND)) {
            expression.second(this.retrieve(CronFieldName.SECOND).getExpression().asString());
        }
        return expression;
    }
}

