/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result.impl;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.search.result.SearchStatus;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class DefaultSearchStatus
implements SearchStatus {
    private final long totalCount;
    private final long errorCount;
    private final long successCount;

    public DefaultSearchStatus(long totalCount, long errorCount, long successCount) {
        this.totalCount = totalCount;
        this.errorCount = errorCount;
        this.successCount = successCount;
    }

    @Override
    public long totalCount() {
        return this.totalCount;
    }

    @Override
    public long successCount() {
        return this.successCount;
    }

    @Override
    public long errorCount() {
        return this.errorCount;
    }

    @Override
    public boolean isSuccess() {
        return this.errorCount() == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSearchStatus that = (DefaultSearchStatus)o;
        if (this.totalCount != that.totalCount) {
            return false;
        }
        if (this.errorCount != that.errorCount) {
            return false;
        }
        return this.successCount == that.successCount;
    }

    public int hashCode() {
        int result = (int)(this.totalCount ^ this.totalCount >>> 32);
        result = 31 * result + (int)(this.errorCount ^ this.errorCount >>> 32);
        result = 31 * result + (int)(this.successCount ^ this.successCount >>> 32);
        return result;
    }

    public String toString() {
        return "DefaultSearchStatus{totalCount=" + this.totalCount + ", errorCount=" + this.errorCount + ", successCount=" + this.successCount + '}';
    }
}

