/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class PhraseQuery
extends AbstractFtsQuery {
    private final List<String> terms = new ArrayList<String>();
    private String field;

    public PhraseQuery(String ... terms) {
        Collections.addAll(this.terms, terms);
    }

    public PhraseQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public PhraseQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.terms.isEmpty()) {
            throw new IllegalArgumentException("Phrase query must at least have one term");
        }
        JsonArray terms = JsonArray.from(this.terms);
        input.put("terms", terms);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

