/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl;

import com.couchbase.client.java.query.dsl.Expression;

public class Sort {
    private final Expression expression;
    private final Order ordering;

    private Sort(Expression expression, Order ordering) {
        this.expression = expression;
        this.ordering = ordering;
    }

    public static Sort def(Expression expression) {
        return new Sort(expression, null);
    }

    public static Sort def(String expression) {
        return Sort.def(Expression.x(expression));
    }

    public static Sort desc(Expression expression) {
        return new Sort(expression, Order.DESC);
    }

    public static Sort desc(String expression) {
        return Sort.desc(Expression.x(expression));
    }

    public static Sort asc(Expression expression) {
        return new Sort(expression, Order.ASC);
    }

    public static Sort asc(String expression) {
        return Sort.asc(Expression.x(expression));
    }

    public String toString() {
        if (this.ordering != null) {
            return this.expression.toString() + " " + (Object)((Object)this.ordering);
        }
        return this.expression.toString();
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

