/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.KeyStoreProvider;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HashicorpVaultKeyStoreProvider
implements KeyStoreProvider {
    private final String endpoint;
    private final String mount;
    private final String token;
    private ObjectMapper mapper = new ObjectMapper();
    private String publicKeyName;
    private String privateKeyName;
    private String signingKeyName;

    public HashicorpVaultKeyStoreProvider(String endpoint, String token) {
        this(endpoint, "secret", token);
    }

    public HashicorpVaultKeyStoreProvider(String endpoint, String mount, String token) {
        this.endpoint = "http://" + endpoint;
        this.mount = mount;
        this.token = token;
    }

    @Override
    public byte[] getKey(String keyName) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet get = new HttpGet(this.endpoint + "/v1/" + this.mount + "/" + keyName);
        get.addHeader("X-Vault-Token", this.token);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new Exception("Store key failed on vault " + response.getStatusLine().toString());
        }
        String storedVal = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
        JsonNode obj = this.mapper.readTree(storedVal);
        client.close();
        return DatatypeConverter.parseBase64Binary((String)obj.get("data").get("value").toString().replace("\"", ""));
    }

    @Override
    public void storeKey(String keyName, byte[] key) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(this.endpoint + "/v1/" + this.mount + "/" + keyName);
        post.addHeader("X-Vault-Token", this.token);
        ObjectNode node = this.mapper.createObjectNode();
        node.put("value", DatatypeConverter.printBase64Binary((byte[])key));
        post.setEntity((HttpEntity)new StringEntity(node.toString(), ContentType.APPLICATION_JSON));
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 204) {
            throw new Exception("Store key failed on vault " + response.getStatusLine().toString());
        }
        client.close();
    }

    @Override
    public String publicKeyName() {
        return this.publicKeyName;
    }

    @Override
    public void publicKeyName(String name) {
        this.publicKeyName = name;
    }

    @Override
    public String privateKeyName() {
        return this.privateKeyName;
    }

    @Override
    public void privateKeyName(String name) {
        this.privateKeyName = name;
    }

    @Override
    public String signingKeyName() {
        return this.signingKeyName;
    }

    @Override
    public void signingKeyName(String name) {
        this.signingKeyName = name;
    }
}

