/*
 * Decompiled with CFR 0.152.
 */
package com.constantcontact.v2.converter.jackson;

import com.constantcontact.v2.converter.jackson.JacksonRequestBodyConverter;
import com.constantcontact.v2.converter.jackson.JacksonResponseBodyConverter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class JacksonConverterFactory
extends Converter.Factory {
    public static final String ISO_8601_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SS'Z'";
    public static final SimpleDateFormat ISO_8601_DATE_FORMAT;
    private static String[] CAMPAIGN_CREATE_UPDATE_FIELDS;
    private final ObjectMapper mapper;
    private final SimpleFilterProvider writerFilterProvider;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        this.mapper = mapper;
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS);
        mapper.getSerializationConfig().with((DateFormat)ISO_8601_DATE_FORMAT);
        SimpleBeanPropertyFilter campaignCreateUpdateFilter = SimpleBeanPropertyFilter.filterOutAllExcept((String[])CAMPAIGN_CREATE_UPDATE_FIELDS);
        this.writerFilterProvider = new SimpleFilterProvider().addFilter("CampaignCreateUpdateFilter", campaignCreateUpdateFilter);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerFor(javaType).with((FilterProvider)this.writerFilterProvider);
        return new JacksonRequestBodyConverter(writer);
    }

    static {
        CAMPAIGN_CREATE_UPDATE_FIELDS = new String[]{"name", "subject", "from_name", "sent_to_contact_lists", "from_name", "from_email", "reply_to_email", "email_content", "text_content", "is_permission_reminder_enabled", "permission_reminder_text", "message_footer"};
        SimpleDateFormat sdf = new SimpleDateFormat(ISO_8601_DATE_PATTERN);
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        ISO_8601_DATE_FORMAT = sdf;
    }
}

